/* Credit-Net Host data structures */

enum Aal_type {
	aal_null = 0,
	aal_type_1 = 1,
	aal_type_2 = 2,
	aal_type_3 = 3,
	aal_type_4 = 4,
	aal_type_5 = 5,
};
typedef enum Aal_type Aal_type;

struct Source_td {
	unsigned int pcr;
	unsigned int scr;
	unsigned int bt;
};
typedef struct Source_td Source_td;

enum Qos_class {
	qos_class_0 = 0, /* unspecified qos class */
	qos_class_1 = 1, /* circuit emulation, CBR video */
	qos_class_2 = 2, /* VBR audio and video */
	qos_class_3 = 3, /* Connection-oriented data */
	qos_class_4 = 4, /* Connectionless data */
};
typedef enum Qos_class Qos_class;

typedef unsigned int Vpvc;

int atm_open(char *dev, int flags);
int atm_connect_pvc(int fd, Vpvc vpvc, Aal_type aal, Source_td td, 
			Qos_class qos, int llc_flag, int snapHeader);
int atm_bind_pvc(int fd, Vpvc vpvc, Aal_type aal, Qos_class qos, int llc_flag,
			int snapHeader);
int atm_send(int fd, char *buf, int len);
int atm_recv(int fd, char *buf, int len);
int add_ip_vc(char *dest, Vpvc vpvc, int flags);
int atm_close (int fd);
int atm_bind_tx_ipvc(int fd, Vpvc vpvc, int snapHeader);
int atm_bind_rx_ipvc(int fd, Vpvc vpvc, int snapHeader);
int atm_bind_skip (int fd);

#define VPI_BITS        8
#define VCI_BITS        16
#define VPI_MASK        ((1 << VPI_BITS) - 1)
#define VCI_MASK        ((1 << VCI_BITS) - 1)

/* vpi and vci encoding and decoding */
#define MKVPVC(vp,vc) \
                        ((Vpvc) (((vp) & VPI_MASK) << VCI_BITS) | ((vc) & VCI_MASK))
#define VP_ID(vpvc)     (((vpvc) >> VCI_BITS) & VPI_MASK)
#define VC_ID(vpvc)     ((vpvc) & VCI_MASK)

typedef enum { CELL_PROCESSING_AAL5, CELL_PROCESSING_DISCARD_HEADER,
    CELL_PROCESSING_RAW } cellProcessing_t;

typedef enum { SCHEDULE_STATIC, SCHEDULE_DYNAMIC } scheduling_t;

typedef unsigned int  vpivci_t;

typedef enum {
    JET_DYNAMIC_LIST_END_MARKER=0xfffd, 
    JET_STATIC_SCHEDULE_DYNAMIC,
    JET_STATIC_SCHEDULE_IDLE
} vcid_t;
 

#define		IP_SVC		1
#define 	IP_PVC		2

typedef struct ijet_ioctl_open_tx {
  cellProcessing_t processing_type;
  scheduling_t scheduling_type;
  vpivci_t vpivci;
  vcid_t vcid;
} ijet_ioctl_open_tx_t;

typedef struct ijet_ioctl_open_rx {
  cellProcessing_t processing_type;
  vpivci_t vpivci;
  vcid_t vcid;
} ijet_ioctl_open_rx_t;

typedef struct {
  unsigned int ip_addr;
  unsigned int tx_vcid;
  unsigned int rx_vcid;
  unsigned int flag;
} arp_entry_t;

#define IJETIOC_VINCE_INIT  _IO('J',24)
#define IJETIOC_ADD_ART	    _IOW('J', 10, unsigned int[4])
#define IJETIOC_DEL_ART     _IOW('J', 11, unsigned int) 
#define IJETIOC_OPEN_TX     _IOWR('J', 15, ijet_ioctl_open_tx_t)
#define IJETIOC_OPEN_RX     _IOWR('J', 16, ijet_ioctl_open_rx_t)
#define IJETIOC_FLUSH_ART   _IO('J',14)
#define IJETIOC_GET_NATE    _IOR('J', 13, unsigned int)
#define IJETIOC_GET_ART	    _IOWR('J', 12, unsigned int[2])

