#include <stdio.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>

#include "../src/vpc/vpc_user.h"

#define crash(fmt,args...) (fprintf(stderr, fmt , ##args),exit(1))

int main (int argc, char **argv)
{
  int fd;
  int error;
  int parms[1];

  if ((fd = open ("/dev/vpc", O_RDWR)) < 0)
    crash ("failure opening device, error=%d\n", errno);

  printf ("Looping forever: hit ^C to stop...\n");
  for (;;)
    if ((error = ioctl (fd, VPC_IOCTL_POLL, parms)) < 0)
      crash ("ioctl returned error code %d\n", errno);
  
  return 0;
}

