#include <sys/types.h>
#include <sys/time.h>
#include <sys/systm.h>
#include <dev/pci/jetland/include/ijet_coding.h>
#include <dev/pci/jetland/include/ijet_jet.h>
#include <dev/pci/jetland/include/ijet_ll.h>
#include <dev/pci/jetland/include/ijet_sonet.h>
#include <dev/pci/jetland/include/ijet_sonet_internals.h>

/*
 * sonet.c: SONET Initialization and Interrupt
 *          handling stuff
 *
 * inherited from Mark Snesrud@Intel, hacked mildly by kosak to conform to our
 * environment.
 */

/* SONET chipset detection module */
public void jet_SonetDetect (int unit)
begin();
{
    warn ("Inside SONET DETECT\n");

    if ((jet_ReadSONET(unit, MASTER_RESET_REG)&0x70) == 0x10) {
	jet_oc12[unit] = TRUE;
	warn ("OC-12 board detected\n");
    }
    else {
	jet_oc12[unit] = FALSE;
	warn ("OC-3 board detected\n");
   }
}
end();

public int jet_SonetInit (int unit)
begin (jet_SonetInit);
{
  unsigned int        time;

  /* Give a RESET to SONET chip */
  jet_WriteSONET (unit, MASTER_RESET_REG, RESET);
  /* Take SONET out of RESET */
  jet_WriteSONET (unit, MASTER_RESET_REG, 0);

  /* Enable Out of Frame, Loss of Frame, and Loss of Signal Interrupts */
  /* Descrambling of the STS-3c stream is enabled */
  jet_WriteSONET (unit, RSOP_CONTROL_REG, OOF_ENAB|LOF_ENAB|LOS_ENAB);

  /* Enable scrambling of the STS-3c stram */
  jet_WriteSONET (unit, TSOP_CONTROL_REG, 0);

  /* Enable Far End Receive Failure and Line AIS Interrupts */
  jet_WriteSONET (unit, RLOP_INTERRUPT_REG, RDI_ENAB|LAIS_ENAB);

  /* Enable Path Remote Defect, Path AIS, and Loss of Pointer Interrupts */
  jet_WriteSONET (unit, RPOP_INT_ENAB_REG, PRDI_ENAB|PAIS_ENAB|LOP_ENAB);

  /* Enable Descrambling of Cell Payload and Coset Polynomial */
  /* Addition to the Receive HEC */
  jet_WriteSONET (unit, RACP_CONTROL_REG, RHCSADD);

  /* Enable Scrambling of Cell Payload and Coset Polynomial */
  /* Addition to the Transmit HEC */
  jet_WriteSONET (unit, TACP_CONTROL_REG, THCSADD);

  /* Specify that transmit FIFO full means FIFO can accept no more writes */
  /* Clearing this bit means FIFO can accept no more than four more writes */
  jet_WriteSONET (unit, TACP_FIFO_CNTRL_REG, TCALEVEL0);

  if (jet_oc12[unit]) { /* SUNI-622 */
    /* Diable Diagnostic Path Loopback */
    jet_WriteSONET (unit, MASTER_CONTROL_MON_REG_622, 0);

    /* Initialize Parallel Output Port values */
    /* SERIAL_LOOPBACK_622, FORCE_LOS_622, and FLOW_CONTROL_THRESH_622 */
    jet_WriteSONET (unit, PARALLEL_OUTPUT_PORT_622, SERIAL_LOOPBACK_622 | 
		    FORCE_LOS_622);
        
    WaitForTicks (100);

    jet_WriteSONET (unit, PARALLEL_OUTPUT_PORT_622, SERIAL_LOOPBACK_622);
  } else {  /* SUNI-LITE */

    /* Enable Cell Delineation Interrupt / Disable Diagnostics Loopback */
    jet_WriteSONET (unit, MASTER_CONTROL_REG, FIX_PTR|LCD_ENAB);

    /* Enable Transmit Reference Out of Lock Interrupt */
    jet_WriteSONET (unit, CLOCK_SYN_REG, TROOL_ENAB);

    /* Enable Receive Data Out of Lock Interrupt */
    jet_WriteSONET (unit, CLOCK_REC_REG, RDOOL_ENAB);

    /* Enable Out of Cell Delineation Interrupt */
    jet_WriteSONET (unit, RACP_INTERRUPT_REG, OOCD_ENAB);

    /* Specify that receive FIFO full means FIFO can accept no more writes */
    /* Clearing this bit means FIFO can accept no more than four more writes */
    jet_WriteSONET (unit, RACP_CONFIG_REG, RCALEVEL0|FSEN|RGFCE);
  }
  return 0;
}
end();


/* Turn on/off SONET Loopback */
public int jet_SetSonetLoopback (int unit, bool loopback)
begin ();
{
  printf ("It's party time!!!! lp %d\n", loopback);
  if (jet_oc12[unit]) {
    printf ("party in the oc12 world\n");
    if (loopback)
      jet_WriteSONET (unit, PARALLEL_OUTPUT_PORT_622, 
		      jet_ReadSONET (unit, PARALLEL_OUTPUT_PORT_622) & 
		      ~SERIAL_LOOPBACK_622);
    else
      jet_WriteSONET (unit, PARALLEL_OUTPUT_PORT_622, 
		      jet_ReadSONET (unit, PARALLEL_OUTPUT_PORT_622) | 
		      SERIAL_LOOPBACK_622);

    jet_WriteSONET (unit, PARALLEL_OUTPUT_PORT_622, 
		    jet_ReadSONET (unit, PARALLEL_OUTPUT_PORT_622) | 
		    FORCE_LOS_622);

    WaitForTicks(5000);

    jet_WriteSONET (unit, PARALLEL_OUTPUT_PORT_622, 
		    jet_ReadSONET (unit, PARALLEL_OUTPUT_PORT_622) & 
		    ~FORCE_LOS_622);
  } else {
    printf ("party in the oc3 world\n");
    if (loopback)
      jet_WriteSONET (unit, MASTER_CONTROL_REG, 
		      jet_ReadSONET (unit, MASTER_CONTROL_REG) | DL_ENAB);
    else
      jet_WriteSONET (unit, MASTER_CONTROL_REG, 
		      jet_ReadSONET (unit, MASTER_CONTROL_REG) & ~DL_ENAB);
  }

  return 0;
}
end ();



private void jet_WriteSONET (int unit, uint32 reg, uint32 value)
begin ();
{
    ((volatile uint8*) jet_sonetBase[unit]) [reg*4]= value;
}
end ();


private uint32 jet_ReadSONET (int unit, uint32 reg)
begin ();
{
    return ((volatile uint8*) jet_sonetBase[unit]) [reg*4];
}
end ();


private void WaitForTicks (int ticks)
begin ();
{
  uint32 i;

  printf ("waiting for %d ticks (not really)\n", ticks);

  for (i=0; i<0x1000000; i++)
    ;
  printf ("done waiting, ha ha\n");
}
end ();
