/* Initialize the jetmsg routines */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <errno.h>

#include <ijet_coding.h>
#include <ijet_ll.h>
#include <jetmsg_user.h>

extern int close (int); /* HACK */

#undef warn
#define warn(FMT,ARGS...) fprintf(stderr,FMT , ##ARGS)
#undef crash
#define crash(FMT,ARGS...) (warn(FMT , ##ARGS),exit(1))

char device[] = "/dev/jetmsg0";

int main(int argc, char **argv)
{
  int fd, error, unit, loopback, parms[2];

  if (argc != 3)
    crash ("Usage: %s unit-num [0/1]\n", argv[0]);
  
  if ((fd=open(device, O_RDWR, 0)) < 0)
    crash ("failed to open %s!\n", device);
  
  unit     = atoi(argv[1]);
  loopback = atoi(argv[2]);
  printf ("Setting loopback for unit %d to %d\n", unit, loopback);

  parms[0] = unit;
  parms[1] = loopback;
  
  if ((error = ioctl (fd, JETMSG_IOCTL_SET_LOOPBACK, parms)) < 0)
    crash ("Set loopback failed: error %d\n", error);
  
  close(fd);
  return 0;
}
