/* RELOAD the microcode */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <errno.h>

#include <ijet_coding.h>
#include <ijet_ll.h>
#include <jetmsg_user.h>


extern int close (int); /* HACK */

#undef warn
#define warn(FMT,ARGS...) fprintf(stderr,FMT , ##ARGS)
#undef crash
#define crash(FMT,ARGS...) (warn(FMT , ##ARGS),exit(1))

int load_ucode (char *fname, uint32 *buffer, int length);

void main(int argc, char **argv)
{
  int fd;
  int buffer [1024];
  int error_length;
  int unit = 0;
  char *filename = "ucode.dat";

  if (argc == 1)
    ;
  else if (argc == 2)
    unit = atoi(argv[1]);
  else if (argc == 3) {
    unit = atoi(argv[1]);
    filename = argv[2];
  } else
    crash ("Usage: %s [unit] [microcode file name, default ucode.dat]\n",
           argv[0]);
  
  error_length = load_ucode (filename, buffer, sizeof(buffer));

  if (error_length < 0)
    crash ("microcode loading FAILED!  you suck\n");

  if ((fd=open("/dev/jetmsg0", O_RDWR, 0)) < 0)
    crash ("failed to open /dev/jetmsg0!\n");

  {
    struct {
      int unit;
      void *ucode;
      int length;
    } parms;
      
    parms.unit   = unit;
    parms.ucode  = buffer;
    parms.length = error_length;

    if (ioctl(fd, JETMSG_IOCTL_RELOAD_UCODE, &parms) < 0)
      crash ("you suck:ioctl failed, errno = %d\n", errno);
  }
  
  close(fd);
  exit(0);
}

/*
 * Read microcode file into array
 */
int load_ucode (char *fname, uint32 *buffer, int capacity)
{
  FILE    *fp;
  char    data[200], dummy[100];
  int     addr, data1, data2, data3;
  int     length= 0;

  printf ("Loading ucode file\n");

  if ((fp=fopen(fname, "r")) == NULL)
    crash ("Unable to load file \"%s\"\n", fname);
  else {
    while (fgets(data, 200, fp) != NULL) {
      if (data[0]=='$') {
        if (capacity < 3*sizeof(uint32)) {
          printf ("buffer not big enough!\n");
          return -2;
        }
        sscanf(data, "$%x: %s  %x %x_%x",
               &addr, dummy, &data3, &data2, &data1);
        *buffer++= addr;
        *buffer++= data2<<16 | (data1&0xFFFF);
        *buffer++= data3&0x0FFF;
        capacity -= 3 * sizeof(uint32);
        length   += 3 * sizeof(uint32);
      }
    }
    fclose(fp);
  }
  printf ("Read ucode file successfully\n");
  return length;
}                              
