%{
#include <fcntl.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "jmexe.h"
%}

%union {
    cmd_t cmd;
    char ident[MAX_IDENT_LENGTH];
}

%type <cmd> command


%token CMD_UNKNOWN
%token CMD_AMBIGUOUS
%token CMD_NULL
%token CMD_HELP
%token CMD_ATM_OPEN
%token CMD_ATM_CLOSE
%token CMD_ATM_SEND
%token CMD_ATM_RECV
%token CMD_SELECT
%token CMD_FIONREAD
%token CMD_ATM_CONNECT_PVC
%token CMD_ATM_BIND_PVC
%token CMD_ATM_BIND_TX_IPVC
%token CMD_ATM_BIND_RX_IPVC

%token JUNK
%token NL
%token <ident> IDENT

%%

all     : command
          {
              PerformCmd ($1);
              Prompt();
          }
        | all command
          {
              PerformCmd ($2);
              Prompt();
          }
        ;

command : CMD_UNKNOWN JUNK NL
          {
              $$.tag = CMD_NULL;
              printf ("Unknown command.  Type 'help' for help\n");
          }
        | CMD_AMBIGUOUS JUNK NL
          {   
              $$.tag = CMD_NULL;
              printf ("Ambiguous command.  Please type a few more characters "
                      "or 'help' for help\n");
          }
        | NL
          {
              $$.tag = CMD_NULL;
          }
        | CMD_HELP JUNK NL
          {
              $$.tag = CMD_HELP;
          }
        | CMD_ATM_OPEN IDENT NL
          {
              int oflag;

              $$.tag = CMD_ATM_OPEN;
              if (strcmp ($2, "r") == 0)
                  oflag = O_RDONLY;
              else if (strcmp ($2, "w") == 0)
                  oflag = O_WRONLY;
              else if (strcmp ($2, "rw") == 0)
                  oflag = O_RDWR;
              else {
                  printf ("unknown flag %s\n", $2);
                  $$.tag = CMD_NULL;
              }

              $$.u.atm_open.oflag = oflag;
          }
        ;

%%

