/* Credit-Net Host data structures */

enum Aal_type {
	aal_null = 0,
	aal_type_1 = 1,
	aal_type_2 = 2,
	aal_type_3 = 3,
	aal_type_4 = 4,
	aal_type_5 = 5,
};
typedef enum Aal_type Aal_type;

struct Source_td {
	unsigned int pcr;
	unsigned int scr;
	unsigned int bt;
};
typedef struct Source_td Source_td;

enum Qos_class {
	qos_class_0 = 0, /* unspecified qos class */
	qos_class_1 = 1, /* circuit emulation, CBR video */
	qos_class_2 = 2, /* VBR audio and video */
	qos_class_3 = 3, /* Connection-oriented data */
	qos_class_4 = 4, /* Connectionless data */
};
typedef enum Qos_class Qos_class;

typedef unsigned int Vpvc;

int atm_open(char *dev, int flags);
int atm_connect_pvc(int fd, Vpvc vpvc, Aal_type aal, Source_td td, 
			Qos_class qos, int llc_flag, int snapHeader);
int atm_bind_pvc(int fd, Vpvc vpvc, Aal_type aal, Qos_class qos, int llc_flag,
			int snapHeader);
int atm_send(int fd, char *buf, int len);
int atm_recv(int fd, char *buf, int len);
int add_ip_vc(char *dest, Vpvc vpvc, int flags);
int atm_close (int fd);
int atm_bind_tx_ipvc(int fd, Vpvc vpvc, int snapHeader);
int atm_bind_rx_ipvc(int fd, Vpvc vpvc, int snapHeader);
int atm_bind_skip (int fd);

#define VPI_BITS        8
#define VCI_BITS        16
#define VPI_MASK        ((1 << VPI_BITS) - 1)
#define VCI_MASK        ((1 << VCI_BITS) - 1)

/* vpi and vci encoding and decoding */
#define MKVPVC(vp,vc) \
                        ((Vpvc) (((vp) & VPI_MASK) << VCI_BITS) | ((vc) & VCI_MASK))
#define VP_ID(vpvc)     (((vpvc) >> VCI_BITS) & VPI_MASK)
#define VC_ID(vpvc)     ((vpvc) & VCI_MASK)


	
