/* this is a test of the ioctl routine */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <errno.h>


#include <sys/device.h>

#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>

#include <ijet_coding.h>
#include <ijet_ll.h>
#include <if_ijet_user.h>
#include <if_ijet.h>

extern int close (int); /* HACK */

void main(int argc, char **argv)
{
  int fd;
  char *data = (char *) 0xdeadbeef;
  iocopy_req_t iocpr;
  ijet_softc_t ijets;
  uint offset, value, addr, a[2];
  char s[20];
  int unit;

  if (argc != 4) {
      printf ("Usage: %s unit offset value\n", argv[0]);
      exit(1);
  }
  unit = atoi(argv[1]);

  if (sscanf(argv[2], "0x%x", &offset) != 1)
    offset = 0x80;
  if (sscanf(argv[3], "0x%x", &value) != 1)
    value = 0xffffffff;

  sprintf(s, "/dev/ijet%d", unit);
  if ((fd=open(s, O_RDWR, 0)) < 0) {
    printf("failed to open device %s!\n",s);
    exit(1);
  }

  if (ioctl(fd, IJETIOC_STRUCT_ADDR, &data) < 0) {
    printf("ioctl failed, errno = %d\n", errno);
    exit(1);
  }


  iocpr.system = data;
  iocpr.user = (char *) &ijets;
  iocpr.len = sizeof(ijet_softc_t);
  
  if (ioctl(fd, IJETIOC_GET_MEM, &iocpr) < 0) {
    printf("ioctl failed, errno = %d\n", errno);
    exit(1);
  }

  addr = ijets.sramBase + offset;

  a[0] = addr;
  a[1] = value;
  if (ioctl(fd, IJETIOC_PUT_UINT32, a) < 0) {
    printf("ioctl failed, errno = %d\n", errno);
    exit(1);
  }
  
  close(fd);
  exit(0);
}
