c
c     dynamic - dynamic redistribution with assignment statements
c
      program main
      parameter(n=1024)

      real a(n,n), b(n,n), mbytes, secs, msecs
      integer clocks
      external timer_stop
      integer timer_stop

c     define the data distributions
      template t(n)
      align a(i,j) with t(i)
      align b(i,j) with t(j)
      distribute t(block(64))

c     Change from a column-wise distribution (b) to a row-wise
c     distribution (a) using an assignment statement.
c     This assignment statement induces an all-to-all personalized
c     communication.

      call fx_sync()
      call timer_start()
      a = b
      clocks = timer_stop()

c     print the result
      mbytes = real(n*n*4)/1000000.0
      secs = real(clocks)/20000000.0
      msecs = secs*1000.0
      print *, "size=",n,"msecs=",msecs,"mbytes/s=",mbytes/secs
      end

