#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <errno.h>
#include <sys/ioctl.h>

#include "../src/vpc/vpc_user.h"

#define crash(fmt,args...) (fprintf(stderr, fmt , ##args),exit(1))

#define PARMCOUNT 3

int main (int argc, char **argv)
{
    int fd;
    int parms[PARMCOUNT];
    int i, error;

    if (argc != PARMCOUNT+1)
	crash ("Usage: %s unit LinkRate (kbps) LineRate (kbps)\n", argv[0]);

    for (i=0; i<PARMCOUNT; i++)
	parms[i] = atoi(argv[i+1]);

    if ((fd = open ("/dev/vpc", O_RDWR)) < 0)
	crash ("failure opening device, error=%d\n", errno);

    if ((error = ioctl (fd, VPC_IOCTL_SET_LINK_RATE, parms)) < 0)
	crash ("ioctl returned error code %d\n", errno);

    return 0;
}
