#include <sys/param.h>
#include <arch/i386/include/psl.h>
#include <sys/malloc.h>
#include <dev/pci/jetland/include/ijet_coding.h>


#if IJETD

public int   ijet_debugmask;
public char  ijet_debugLogString[256];
public int   ijet_debugLogIndex;
public char *ijet_debugLogBuffer;

public int ijet_debug_indentLevel;

public int ijet_PutLogString (void)
{
    static int mallocFailed = FALSE;
    char *s = ijet_debugLogString;

    if (mallocFailed)
        return 0;

    if (!ijet_debugLogBuffer) {
        if ((ijet_debugLogBuffer =
             malloc (IJET_DEBUG_LOG_SIZE, M_DEVBUF, M_WAITOK))
            == NULL) {
            mallocFailed = TRUE;
            printf ("PutLogString: can't get enough memory!\n");
            return 0;
        }

        ijet_debugLogIndex = 0;
    }

    while (*s) {
        ijet_debugLogBuffer[ijet_debugLogIndex++] = *s;
        s++;
        if (ijet_debugLogIndex == IJET_DEBUG_LOG_SIZE)
            ijet_debugLogIndex = 0;
    }
}

#endif

