#ifndef _TIMESTAMP_H_
#define _TIMESTAMP_H_

#include <sys/types.h>

typedef unsigned int u_int32;
typedef unsigned long long int u_int64;

#define TDIFF(t1, t2) \
  ((t2 > t1)? (t2 - t1) : (t2 + ~t1 + 1))

static __inline u_int64 timestamp(void)
{
  union {
    u_int64 l;
    struct {
      u_int32 low;
      u_int32 high;
    } s;
  } ts;

  __asm __volatile(".byte 0x0f; .byte 0x31":
		   "=a" (ts.s.low), "=d" (ts.s.high));
  return ts.l;
}

#endif /* _TIMESTAMP_H_ */
