#ifndef _DYNARRAY_H_
#define _DYNARRAY_H_

#include "glob.h"

#pragma interface

//------------------------------------------------------------------------

template <class T> class dynarray_t {
  T *base;
  int capacity;

  void Grow (int desiredCapacity);

public:
  int size;

  dynarray_t () : base(NULL), capacity(0), size(0) {}
  ~dynarray_t() {Free (base);}

  T& operator[] (int index)
  {
    Grow (index+1);
    return base[index];
  }
};

template <class T> void dynarray_t<T>::Grow (int desiredCapacity)
{
  if (desiredCapacity > capacity) {
    while (desiredCapacity > capacity)
      capacity = capacity*2+1;
    debug.form ("increasing array capacity to %d entries.\n", capacity);
    base = (T*) Realloc (base, capacity*sizeof(T));
  }
  if (desiredCapacity > size)
    size = desiredCapacity;
}

#endif /* _DYNARRAY_H_ */

