#include "glob.h"

output_t out_   (cout);
output_t warn_  (cerr);
output_t debug_ (cerr);

ostream &output_t::operator() (const char *func, const char *file,
                               const int line)
{
  if (file)
    stream << "[" << file << "," << line << "] ";
  if (func)
    stream << func << "(): ";
  return stream;
}


void output_t::SetMask (char *s)
{
  mask = 0;
  while (*s) {
    int bitpos;
    switch (*s) {
    case '0'...'5': bitpos = *s-'0';     break;
    case 'a'...'z': bitpos = *s-'a'+6;   break;
    case '*': mask=0xffffffff; bitpos=0; break;
    default: crash (.form ("bad character %c in format\n", *s));
    }
    mask |= 1<<bitpos;
    s++;
  }
}
