#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <sys/errno.h>
#include <jetmsg.h>
#include <jetmsg_user.h>



int atm_open(char *dev, int flags)
{
    int length = strlen(dev);
    char namebuf [length+2];
    char minor;

    strcpy (namebuf, dev);

    /* searches all the devices until it finds one that isn't busy,
     * or another error occurs */

    for (minor='a'; minor<='z'; minor++) {
        int fd;

        namebuf[length]   = minor;
        namebuf[length+1] = 0;

        if ((fd = open (namebuf, flags)) >= 0)
            return fd;

        if (errno != EBUSY)  /* some other error has occurred */
            return -1;
    }
   
    errno = EMFILE;
    return -1;
}


int atm_close (int fd)
{
    return close (fd);
}


int atm_send(int fd, char *buf, int len)
{
    return write (fd, buf, len);
}


int atm_recv(int fd, char *buf, int len)
{
    return read (fd, buf, len);
}


int atm_bind_pvc (int fd, Vpvc vpvc, Aal_type aal, Qos_class qos, int llc_flag,
			int snapHeader)
{
    int parms[3] = {vpvc, llc_flag, snapHeader};
    return ioctl (fd, JETMSG_IOCTL_OPEN_RX, parms);
}


int atm_connect_pvc (int fd, Vpvc vpvc, Aal_type aal, Source_td td, 
                     Qos_class qos, int llc_flag, int snapHeader)
{
    int parms[3] = {vpvc, llc_flag, snapHeader};
    return ioctl (fd, JETMSG_IOCTL_OPEN_TX, parms);
}


int atm_bind_tx_ipvc(int fd, Vpvc vpvc, int snapHeader)
{
    int parms[2] = {vpvc, snapHeader};
    return ioctl (fd, JETMSG_IOCTL_BIND_TX_IPVC, parms);
}


int atm_bind_rx_ipvc(int fd, Vpvc vpvc, int snapHeader)
{
    int parms[2] = {vpvc, snapHeader};
    return ioctl (fd, JETMSG_IOCTL_BIND_RX_IPVC, parms);
}

int atm_bind_skip (int fd)
{
    return ioctl (fd, JETMSG_IOCTL_BIND_SKIP);
}

