#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <errno.h>

#include <ijet_coding.h>
#include <jetmsg.h>

extern int close (int); /* HACK */

#undef warn
#define warn(FMT,ARGS...) fprintf(stderr,FMT , ##ARGS)
#undef crash
#define crash(FMT,ARGS...) (warn(FMT , ##ARGS),exit(1))

char device[] = "/dev/jetmsg0";

int main(int argc, char **argv)
{
    int fd0, fd1;
    int vpivci0, vpivci1;
    int snap;
    int error;

    if (argc == 4) {
        vpivci0 = atoi(argv[1]);
        vpivci1 = atoi(argv[2]);
        snap    = atoi(argv[3]);
    }
    else
        crash ("Usage: %s vpivci vpivci snap\n", argv[0]);

    if ((fd0 = atm_open(device, O_WRONLY)) < 0)
        crash ("atm_open \"%s\" failed, error=%d!\n", device, errno);
    if ((fd1 = atm_open(device, O_WRONLY)) < 0)
        crash ("atm_open \"%s\" failed, error=%d!\n", device, errno);
    warn ("Using fd's %d and %d\n", fd0, fd1);
    
    if ((error = atm_connect_pvc (fd0, vpivci0, 0, (Source_td){0}, 0,
		1, 2054)) < 0)
        crash ("atm_connect_pvc failed, errno=%d\n", errno);
    if ((error = atm_bind_tx_ipvc (fd1, vpivci1, snap)) < 0)
        crash ("atm_bind_tx_ipvc failed, errno=%d\n", errno);

    {
        static char charset[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
            "abcdefghijklmnopqrstuvwxyz"
                "0123456789";
        char message[4096];
        
     int i;
        for (i=0;i<sizeof(message);i++)
            message[i]=charset[i%(sizeof(charset)-1)];

        for (;;)
        {
            char buf[128];
            int choice, length;
            int error=0;

            printf ("choices:\n");
            printf ("1 send a buffer via msg\n");
            printf ("2 send a buffer via IP\n");
            printf ("3 quit\n");
            printf ("\nchoice: ");
            fgets (buf, sizeof(buf), stdin);
            choice = atoi(buf);
            if (choice != 3) {
              printf ("how many characters? ");
              fgets (buf, sizeof(buf), stdin);
              length= atoi(buf);
            }
          
            switch (choice) {
                case 1: {
                    error = atm_send (fd0, message, length);
                } break;

                case 2: {
                    error = atm_send (fd1, message, length);
                } break;

                case 3: {
                    goto cowland;
                } break;

                default: {
                    printf ("yeah, whatever dude\n");
                } break;
            }

            if (error < 0)
                printf ("return value %d, errno %d\n", error, errno);
            else
                printf ("number of chars written=%d\n", error);
        }
    }

cowland:
    atm_close(fd0);
    atm_close(fd1);
    return 0;
}
