#ifndef _JMEXE_H_
#define _JMEXE_H_

#include <ijet_coding.h>
#include <sys/time.h>

#define MAX_IDENT_LENGTH (256)

typedef struct {
    int dummy;
} cmd_help_t;

typedef struct {
    int oflag;
} cmd_atm_open_t;

typedef struct {
    int fd;
} cmd_atm_close_t;

typedef struct {
    int fd;
    int length;
    char message[4096];
} cmd_atm_send_t;

typedef struct {
    int fd;
    int length;
} cmd_atm_recv_t;

typedef struct {
    int limfd;
    fd_set rset;
    fd_set wset;
    bool timeoutEnabled;
    struct timeval tv;
} cmd_select_t;

typedef struct {
    int dummy;
} cmd_fionread_t;

typedef struct {
    int fd;
    int vpvc;
} cmd_atm_connect_pvc_t, cmd_atm_bind_pvc_t;

typedef struct {
    int fd;
    int vpvc;
    int snap;
} cmd_atm_bind_tx_ipvc_t, cmd_atm_bind_rx_ipvc_t;


typedef struct {
    int tag;
    union {
        cmd_help_t             help;
        cmd_atm_open_t         atm_open;
        cmd_atm_close_t        atm_close;
        cmd_atm_send_t         atm_send;
        cmd_atm_recv_t         atm_recv;
        cmd_select_t           select;
        cmd_fionread_t         fionread;
        cmd_atm_connect_pvc_t  atm_connect_pvc;
        cmd_atm_bind_pvc_t     atm_bind_pvc;
        cmd_atm_bind_tx_ipvc_t atm_bind_tx_ipvc;
        cmd_atm_bind_rx_ipvc_t atm_bind_rx_ipvc;
    } u;
} cmd_t;

#endif /* _JMEXE_H_ */
