#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <errno.h>

#include <ijet_coding.h>
#include <jetmsg.h>
#include "jmexe.h"
#include "y.tab.h"

extern int close (int); /* HACK */

#undef warn
#define warn(FMT,ARGS...) fprintf(stderr,FMT , ##ARGS)
#undef crash
#define crash(FMT,ARGS...) (warn(FMT , ##ARGS),exit(1))

static char *helpMenu[] = {
    "Commands:",
    "",
    "help",
    "atm_open r/w/rw",
    "atm_close fd",
    "atm_send fd [length/message]",
    "atm_recv fd [length]",
    "select [r fdlist] [w fdlist] [timeout]",
    "fionread fd",
    "atm_connect_pvc fd [vpi] vci",
    "atm_bind_pvc fd [vpi] vci",
    "atm_bind_tx_ipvc fd [vpi] vci snap",
    "atm_bind_rx_ipvc fd [vpi] vci snap",
    "quit",
    "",
    "Type only as many characters as you need to disambiguate",
    NULL
};

char device[] = "/dev/jetmsg0";

private void PrintText (char **text);
private void PrintBuffer (char *buffer, int length);

int main(int argc, char **argv)
{
    yyparse ();
    return 0;
}


void Prompt (void)
{
    printf ("Blow me: ");
}


int yywrap ()
{
    crash ("yywrap called, I forget why\n");
}


int yyerror ()
{
    crash ("yyerror called, I forget why\n");
}


public void PerformCmd (cmd_t cmd)
{
    int error = 0;

    switch (cmd.tag) {
        case CMD_NULL: break;

        case CMD_HELP: {
            error = 0;
            PrintText (helpMenu);
        } break;

        case CMD_ATM_OPEN: {
            error = atm_open (device, cmd.u.atm_open.oflag);
            printf ("fd is %d\n", error);
        } break;

        case CMD_ATM_CLOSE: {
            error = atm_close (cmd.u.atm_close.fd);
        } break;

        case CMD_ATM_SEND: {
            int offset = 0;
            int length = cmd.u.atm_send.length;
            while (length) {
                error = atm_send (cmd.u.atm_send.fd,
                                  cmd.u.atm_send.message+offset,
                                  length);
                if (error < 0)
                    break;
                printf ("requested %d bytes, sent %d bytes\n", length, error);
                offset += error;
                length -= error;
            }
        } break;

        case CMD_ATM_RECV: {
            int length = cmd.u.atm_recv.length;
            char buffer[length];
            while (length) {
                error = atm_recv (cmd.u.atm_recv.fd, buffer, length);
                if (error < 0)
                    break;
                printf ("requested %d bytes, received %d bytes\n", length,
                        error);
                PrintBuffer (buffer, error);
                length -= error;
            }
        } break;

        case CMD_SELECT: {
            fd_set rset = cmd.u.select.rset;
            fd_set wset = cmd.u.select.wset;
            int i;

            if (cmd.u.select.timeoutEnabled)
                error = select (cmd.u.select.limfd, &rset, &wset, NULL,
                                &cmd.u.select.tv);
            else
                error = select (cmd.u.select.limfd, &rset, &wset, NULL,
                                NULL);
        
            warn ("select returned %d\n", error);
            printf ("read set:{");
            for (i=0; i<cmd.u.select.limfd; i++)
                if (FD_ISSET (i, &rset))
                    printf ("%d ", i);
            printf ("}\nwrite set:{");
            for (i=0; i<cmd.u.select.limfd; i++)
                if (FD_ISSET (i, &rset))
                    printf ("%d ", i);
            printf ("}\n");
        } break;

        case CMD_FIONREAD: {
            printf ("not implemented yet\n");
            error = 12;
        } break;

        case CMD_ATM_CONNECT_PVC: {
            error = atm_connect_pvc (cmd.u.atm_connect_pvc.fd,
                                     cmd.u.atm_connect_pvc.vpvc,
                                     0, (Source_td){0}, 0);
        } break;
 
        case CMD_ATM_BIND_PVC: {                                           
            error = atm_bind_pvc (cmd.u.atm_bind_pvc.fd,
                                  cmd.u.atm_bind_pvc.vpvc,
                                  0, 0);
        } break;                          

        case CMD_ATM_BIND_TX_IPVC: {
            error = atm_bind_tx_ipvc (cmd.u.atm_bind_tx_ipvc.fd,
                                      cmd.u.atm_bind_tx_ipvc.vpvc,
                                      cmd.u.atm_bind_tx_ipvc.snap);
        } break;

        case CMD_ATM_BIND_RX_IPVC: {
            error = atm_bind_rx_ipvc (cmd.u.atm_bind_rx_ipvc.fd,
                                      cmd.u.atm_bind_rx_ipvc.vpvc,
                                      cmd.u.atm_bind_rx_ipvc.snap);
        } break;
        
        default: {
            crash ("Unknown tag %d\n", cmd.tag);
        } break;
    }

    if (error == 0)
        printf ("Success!\n");
    else
        printf ("Error return %d, errno=%d\n", error, errno);
}


private void PrintText (char **text)
{
    assert (text != NULL);
    while (*text) {
        printf ("%s\n", *text);
        text++;
    }
}


private void PrintBuffer (char *buffer, int length)
{
    int i;
    printf ("[");
    for (i=0; i<length; i++)
        printf ("%c", buffer[i]);
    printf ("]\n");
}
