/* this dumps the current log buffer */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <errno.h>
#include <unistd.h>

#include <sys/device.h>

#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <arpa/inet.h>

#include <ijet_coding.h>
#include <ijet_ll.h>
#include <if_ijet_user.h>
#include <if_ijet.h>

extern int close (int);

int main(int argc, char **argv)
{
    struct {
        int index;
        char *buffer;
        int bytesRead;
    } parms;
    int fd;
    int waitFlag = FALSE;

    char textBuffer[1024];

    if ((fd=open("/dev/ijet0", O_RDWR, 0)) < 0) {
        fprintf(stderr, "failed to open device!\n");
        exit(1);
    }

    if (argc > 1) {
        if (argc == 2) {
            if (strcmp(argv[1],"-f") == 0)
                waitFlag = TRUE;
            else goto parmerr;
        } else goto parmerr;
    }

    parms.index  = 0;
    parms.buffer = textBuffer;
    do {
        do {
            parms.bytesRead = sizeof(textBuffer);
            
            if (ioctl(fd, IJETIOC_READLOG, &parms) < 0) {
                fprintf (stderr, "\nioctl failed, errno = %d\n", errno);
                exit(1);
            }
            
            if (parms.bytesRead)
                fprintf (stderr, "%.*s", parms.bytesRead, textBuffer);
            
        } while (parms.bytesRead == sizeof(textBuffer));

        if (waitFlag)
            sleep (1);
    }
    while (waitFlag);
    close(fd);
    return 0;

parmerr: 
    printf ("Usage: %s [-f]\n", argv[0]);
    printf ("-f means keep waiting for more stuff to print\n");
    return 0;
}

