#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <errno.h>


#include <sys/device.h>

#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>

#include <ijet_coding.h>
#include <ijet_ll.h>
#include <if_ijet_user.h>
#include <if_ijet.h>

extern int close (int); /* HACK */

void main(int argc, char **argv)
{
  int fd;
  uint offset, pcitag, params[3];

  if (argc<2 || sscanf(argv[1], "0x%x", &offset) != 1)
    offset = 0x0;
  
  if (argc<3 || sscanf(argv[2], "0x%x", &pcitag) != 1)
    pcitag = 0xf1c600;
  
  printf("register is 0x%x, pcitag is 0x%x\n", offset, pcitag);
  if ((fd=open("/dev/ijet0", O_RDWR, 0)) < 0) {
    printf("failed to open device!\n");
    exit(1);
  }

  params[0]= offset;
  params[1]= 0xdeadbeef;
  params[2]= pcitag;
 
  printf("pci register 0x%x", offset);
  fflush(stdout);
  if (ioctl(fd, IJETIOC_READ_PCI, params) < 0) {
    printf("ioctl failed, errno = %d\n", errno);
    exit(1);
  }
  
  printf(" is 0x%x\n", params[1]);
  
  close(fd);
  exit(0);
}
