#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <netdb.h>
#include <varargs.h>
#include <sys/socket.h>
#include <errno.h>
#include <string.h>
#include "chost.h"
#include <sys/filio.h>
#include <fcntl.h>
#include <arpa/inet.h>
#include <sys/ioctl.h>
#include <unistd.h>

static char *usage = "Usage: ijetarp OPTION

OPTIONs are:
hostname                              (display an ARP entry)
-a                                    (display all ARP entries and VCs)
-f                                    (delete all dynamic ARP entries and SVCs)
-c host vpi vci                       (establish Classical IP PVC)
-r host                               (remove Classical IP PVC)
-n NSAPaddr                           (configure our NSAP address)
-z                                    (get our NSAP address)
-o host NSAPaddr                      (add NSAP addr to ARP table)
-p NSAPaddr                           (put (set) ARP Server address)
-g                                    (get ARP Server address)
-v                                    (display ARP Server VPVC)";

void ijetAddIpPvc(arp_entry_t *ate, int vpi, int vci);
void ijetDelIpPvc(unsigned int ipaddr);
void ijetFlushArpTable(void);
void ijetPrintArpTable(void);
void ijetGetArpEntry(unsigned int ipaddr);
char *sendVinceSkipCommand(char *command);

int main (int argc, char *argv[])
{
    arp_entry_t	ate;
    char command[100];
    char *result; 
    unsigned int vpi = 0, vci = 0;
    struct hostent *phe;
    struct sockaddr_in sin;
    argc--;
    argv++;

    if (argc < 1) {
	printf ("%s\n", usage);
	exit(1);
    }
    
    if (*argv[0] == '-') {
    	switch (*++argv[0]) {
	    case 'a': {
		ijetPrintArpTable();
		}
		break;
	    case 'f': {
		ijetFlushArpTable();
		}
		break;
	    case 'c': {
		if (argc != 4) {
			printf("%s\n", usage);
			exit(1);
		}
		if ((phe = gethostbyname(argv[1])) != NULL) {
		    bcopy(phe->h_addr, (char *) &sin.sin_addr, phe->h_length);
		    ate.ip_addr = sin.sin_addr.s_addr;
		}
		else if ((ate.ip_addr = inet_addr(argv[1])) == INADDR_NONE) {
		    perror("Cannot get host IP address");
		    exit(1);
		}
		ate.flag = IP_PVC;
	 	vpi = atoi(argv[2]);
		vci = atoi(argv[3]);
		ijetAddIpPvc(&ate, vpi, vci);
		}
		break;
	    case 'r': {
                if (argc != 2) { 
                        printf("%s\n", usage);
                        exit(1);
                }
                if ((phe = gethostbyname(argv[1])) != NULL) {
                    bcopy(phe->h_addr, (char *) &sin.sin_addr, phe->h_length);
                    ate.ip_addr = sin.sin_addr.s_addr;
                }
                else if ((ate.ip_addr = inet_addr(argv[1])) == INADDR_NONE) {
                    perror("Cannot get host IP address");
                    exit(1);
                }
		ijetDelIpPvc(ate.ip_addr);
		}
		break;
	    case 'n': {
                if (argc != 2) { 
                        printf("%s\n", usage);
                        exit(1);
                }
                if (strlen(argv[1]) != 47) {
                        printf("Invalid NSAP address\n");
                        exit(1);
                }
		sprintf(command, "add_translation switch:a %s\n", argv[1]);
		result = sendVinceSkipCommand(command);
		free(result);
		sprintf(command, "add_translation %s switch:a\n", argv[1]);
		result = sendVinceSkipCommand(command);
		free(result);
		}
		break;
	    case 'z': {
		sprintf(command, "find_translation switch:a nsap\n");
		result = sendVinceSkipCommand(command);
		printf("NSAP address for ijet0 is %s\n", result);
		free(result);
		}
		break;
	    case 'o': {
                if (argc != 3) { 
                        printf("%s\n", usage);
                        exit(1);
                }
                if ((phe = gethostbyname(argv[1])) != NULL) {
                    bcopy(phe->h_addr, (char *) &sin.sin_addr, phe->h_length);
                    ate.ip_addr = sin.sin_addr.s_addr;
                }
                else if ((ate.ip_addr = inet_addr(argv[1])) == INADDR_NONE) {
                    perror("Cannot get host IP address");
                    exit(1);
                }
		if ((argc < 3) || (strlen(argv[2]) != 47)) {
			printf("Invalid NSAP address\n");
			exit(1);
		}
		sprintf(command, "add_translation ip:%d.%d.%d.%d %s\n", 
			ate.ip_addr & 255, (ate.ip_addr >> 8) & 255,
			(ate.ip_addr >> 16) & 255, ate.ip_addr >> 24, argv[2]);
		result = sendVinceSkipCommand(command);
		free(result);
                sprintf(command, "add_translation %s ip:%d.%d.%d.%d\n", 
			argv[2],
                        ate.ip_addr & 255, (ate.ip_addr >> 8) & 255,
                        (ate.ip_addr >> 16) & 255, ate.ip_addr >> 24);
                result = sendVinceSkipCommand(command);
		free(result);
		}
		break;
	    case 'p': {
		printf("Not currently supported\n");
 /*               if (argc != 2) { 
                        printf("%s\n", usage);
                        exit(1);
                }
		printf("Set ARP server address\n");
                if ((argc < 2) || (strlen(argv[1]) != 47)) {              
                        printf("Invalid NSAP address\n");
                        exit(1);
                }
		sprintf(command, "set_arp_server_address %s\n", argv[1]);
		result = sendVinceSkipCommand(command); 
		free(result); */
		}
		break;
	    case 'g': {
		sprintf(command, "get_arp_server_address\n");
		result = sendVinceSkipCommand(command);
		printf("ARP server address is %s\n", result);
		free(result);
		}
		break;
	    case 'v':
		printf("Not currently supported\n");
		break;
	    default: {
		printf("%s\n", usage);
		exit(1);
	    }
	}
    }
    else {
        if (argc != 1) {
            printf("%s\n", usage);
            exit(1);
        }
        if ((phe = gethostbyname(argv[0])) != NULL) {
            bcopy(phe->h_addr, (char *) &sin.sin_addr, phe->h_length);
            ate.ip_addr = sin.sin_addr.s_addr;
        }
        else if ((ate.ip_addr = inet_addr(argv[0])) == INADDR_NONE) {
            perror("Cannot get host IP address");
            exit(1);
        }
        ijetGetArpEntry(ate.ip_addr);
    }
    
    exit(0);
}

void ijetAddIpPvc(arp_entry_t *ate, int vpi, int vci)
{
  int error, fd;
  Vpvc vpvc;

  ijet_ioctl_open_tx_t open_tx = {
        CELL_PROCESSING_AAL5,
        SCHEDULE_STATIC,
        0, 0
  };
  ijet_ioctl_open_rx_t open_rx = {
        CELL_PROCESSING_AAL5,
        0, 0
  };

  if ((fd = open("/dev/ijet0", O_RDWR)) < 0) {
	perror("Cannot open ijet0");
	exit(1);
  }
  vpvc = MKVPVC(vpi, vci);
  open_tx.vpivci = vpvc;
  if ((error = ioctl (fd, IJETIOC_OPEN_TX, &open_tx)) < 0) {
     perror("ioctl IJETIOC_OPEN_TX");
  exit(1);
  }
  open_rx.vpivci = vpvc;
  if ((error = ioctl (fd, IJETIOC_OPEN_RX, &open_rx)) < 0) {
     perror("ioctl IJETIOC_OPEN_RX");
     exit(1);
  }
  ate->tx_vcid = open_tx.vcid;
  ate->rx_vcid = open_rx.vcid;
  if ((error = ioctl (fd, IJETIOC_ADD_ART, ate)) < 0) {
       perror("ioctl IJETIOC_ADD_ART");
       exit(1);
  }
  close(fd);
}

void ijetPrintArpTable()
{
  typedef struct {
	unsigned int ipaddr;
	unsigned int vpvc;
	unsigned int flag;
	unsigned int idle;
  } arpent_t;
  struct {
	int nate;
	arpent_t *atebuffer;
  } parms;
  int error, fd;
  int nate;
  arpent_t *ate, current_ate;
  struct in_addr in;
 
  if ((fd = open("/dev/ijet0", O_RDWR)) < 0) {
        perror("Cannot open ijet0");
        exit(1);
  }
  if ((error = ioctl (fd, IJETIOC_GET_NATE, &nate)) < 0) {
       perror("ioctl IJETIOC_GET_NATE");
       exit(1);
  }
  /* printf("Number of ARP entries %d\n", nate);*/

  if (nate) {
    ate = (arpent_t *) malloc(nate*sizeof(arpent_t));
    parms.atebuffer = ate;
    parms.nate = nate;
    if ((error = ioctl (fd, IJETIOC_GET_ART, &parms)) < 0) {
         perror("ioctl IJETIOC_GET_ART");
         exit(1);
    }
    if (parms.nate) {
	printf("IP Address \t VPI \t VCI \t \t Type \t \t Idle\n");
	while (parms.nate > 0) {
		current_ate = ate[parms.nate - 1];
		in.s_addr = current_ate.ipaddr;
		printf("%s \t  %d \t  %d \t %s \t   %d\n", inet_ntoa(in),
			VP_ID(current_ate.vpvc), VC_ID(current_ate.vpvc),
			(current_ate.flag-1)?"Classical IP PVC":
			"Classical IP SVC", current_ate.idle);
		parms.nate--; 
	}
	free(ate);
     }
     else {
	printf ("Did not get any arp table entries\n");
	free(ate);
	close(fd);
	exit(1);
     }
  }
  else {
	close(fd);
	exit(0);
  }
  close(fd);
}

void ijetGetArpEntry(unsigned int ipaddr)
{
  typedef struct {
        unsigned int ipaddr;
        unsigned int vpvc;
        unsigned int flag;
        unsigned int idle;
  } arpent_t;
  struct {
        int nate;
        arpent_t *atebuffer;
  } parms;
  int error, fd, found = 0;
  int nate;
  arpent_t *ate, current_ate;
  struct in_addr in;

  if ((fd = open("/dev/ijet0", O_RDWR)) < 0) {
        perror("Cannot open ijet0");
        exit(1);
  }
  if ((error = ioctl (fd, IJETIOC_GET_NATE, &nate)) < 0) {
       perror("ioctl IJETIOC_GET_NATE");
       exit(1);
  }
  /* printf("Number of ARP entries %d\n", nate);*/

  if (nate) {
    ate = (arpent_t *) malloc(nate*sizeof(arpent_t));
    parms.atebuffer = ate;
    parms.nate = nate;
    if ((error = ioctl (fd, IJETIOC_GET_ART, &parms)) < 0) {
         perror("ioctl IJETIOC_GET_ART");
         exit(1);
    }
    if (parms.nate) {
        while (parms.nate > 0) {
                current_ate = ate[parms.nate - 1];
                in.s_addr = current_ate.ipaddr;
		if (current_ate.ipaddr == ipaddr) {
		  if (!found)
                    printf("IP Address \t VPI \t VCI \t \t Type \t \t Idle\n");
	          found = 1;
                  printf("%s \t  %d \t  %d \t %s \t   %d\n", inet_ntoa(in),
                        VP_ID(current_ate.vpvc), VC_ID(current_ate.vpvc),
                        (current_ate.flag-1)?"Classical IP PVC":
                        "Classical IP SVC", current_ate.idle);
		}
                parms.nate--;
        }
        free(ate);
     }
     else {
        printf ("Did not get any arp table entries\n");
        free(ate);
        close(fd);
        exit(1);
     }
  }
  else {
        close(fd);
        exit(0);
  }
  close(fd);
}

void ijetDelIpPvc(unsigned int ipaddr)
{
  int error, fd;

  if ((fd = open("/dev/ijet0", O_RDWR)) < 0) {
        perror("Cannot open ijet0");
        exit(1);
  }
  if ((error = ioctl (fd, IJETIOC_DEL_ART, &ipaddr)) < 0) {
       perror("ioctl IJETIOC_DEL_ART");
       exit(1);
  }
  close(fd);
}

void ijetFlushArpTable()
{
  int error, fd;

  if ((fd = open("/dev/ijet0", O_RDWR)) < 0) {
        perror("Cannot open ijet0");
        exit(1);
  }
  if ((error = ioctl (fd, IJETIOC_FLUSH_ART, 0)) < 0) {
       perror("ioctl IJETIOC_FLUSH_ART");
       exit(1);
  }
  close(fd);
}

char *sendVinceSkipCommand (char *command)
{
  struct protoent *ppe;
  struct sockaddr_in sin;
  struct hostent *phe;
  struct servent *pse;
  int s, inchars, outchars, error;
  char  *response;
  char hostname[80];

  response = malloc(100);
  /* printf("Command: %s\n", command); */
  bzero((char *) &sin, sizeof(sin));
  sin.sin_family = AF_INET;

  if ((error = gethostname(hostname, 80)) < 0) {
	perror("gethostname");
	exit(1);
  }
  if ((phe = gethostbyname(hostname)) != NULL) 
    	bcopy(phe->h_addr, (char *) &sin.sin_addr, phe->h_length);
  else {
	perror("gethostbyname");
	exit(1);
  }

  if ((pse = getservbyname("skip", "tcp")) != NULL) 
	sin.sin_port = pse->s_port;
  else if ((sin.sin_port = htons((u_short) atoi("3795"))) == 0) {
	perror("getservbyname");
	exit(1);
  }

  if ((ppe = getprotobyname("tcp")) == 0) {
	perror("getprotobyname");
	exit(1);
  }

  s = socket(AF_INET, SOCK_STREAM, ppe->p_proto);
  if (s < 0) {
	perror("can't create socket");
	exit(1);
  }

  if (connect(s, (struct sockaddr *)&sin, sizeof(sin)) < 0) {
	perror("Cannot connect to Vince");
	exit(1);
  }

  outchars = strlen(command);
  (void) write(s, command, outchars);
  inchars = read(s, response, 100);
  response[inchars] = '\0';

  close(s);
  /* printf("Response: %s\n", response); */
  return(response);
}


