/* this is a test of the ioctl routine */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <errno.h>


#include <sys/device.h>

#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>

#include <ijet_coding.h>
#include <ijet_ll.h>
#include <if_ijet_user.h>
#include <if_ijet.h>

extern int close (int fd); /* HACK */

void main(int argc, char **argv)
{
  int fd;
  iocopy_req_t iocpr;
  uint value, addr;

  if (argc<2 || sscanf(argv[1], "0x%x", &addr) != 1)
    addr = 0x0;

  printf("using addr 0x%x\n", addr);
  if ((fd=open("/dev/ijet0", O_RDWR, 0)) < 0) {
    printf("failed to open device!\n");
    exit(1);
  }

  iocpr.system = (caddr_t) addr;
  iocpr.user = (char *) &value;
  iocpr.len = 4;
  
  if (ioctl(fd, IJETIOC_GET_MEM, &iocpr) < 0) {
    printf("ioctl failed, errno = %d\n", errno);
    exit(1);
  }

  printf ("value at 0x%x is 0x%x\n", addr, value);
  
  close(fd);
  exit(0);
}
