/* this is a test of the ioctl routine */

#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <errno.h>

#include <sys/device.h>

#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <netinet/if_ether.h>
#include <arpa/inet.h>

#include <ijet_coding.h>
#include <ijet_ll.h>
#include <if_ijet_user.h>
#include <if_ijet.h>

extern int close (int fd);  /* HACK */

int main(int argc, char **argv)
{
    int fd;
    int debugmask = 0;
    int index;
    
    if (argc > 2)
        goto PARMERR;

    if (argc == 2) {
        if (strcmp(argv[1],"-all") == 0)
            debugmask = 0xffffffff;
        else {
            char *cp = argv[1];

            while (*cp) {
                char ch=*cp;
                switch (ch) {
                    case '0'...'5': index=ch-'0'; break;
                    case 'a'...'z': index=ch-'a'+6; break;
                    default: goto PARMERR;
                }
                debugmask |= (1<<index);
                cp++;
            }
        }
    }

    printf ("debugmask is 0x%x\n", debugmask);
    
    if ((fd=open("/dev/ijet0", O_RDWR, 0)) < 0) {
        printf("failed to open device!\n");
        exit(1);
    }
    
    if (ioctl(fd, IJETIOC_DEBUG_MASK, &debugmask) < 0) {
        printf ("ioctl failed, errno = %d\n", errno);
        exit(1);
    }
    
    close(fd);
    return 0;

PARMERR:
    printf ("Usage: %s [flags]\n", argv[0]);
    printf ("flags are characters from the set {0-5,a-z}\n");
    return -1;
}
