//------------------------------------------------------------------------------------
//                                                                     
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  1999-2000 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                      
//-----------------------------------------------------------------------------------
// tim.uc
// IXPblock timer macros
//
//
// system: IXP1200
// subsystem: IO microcode
// usage: library macros
// author: dfh Jan 12, 1999	
//
// revisions:	dfh Apr 6, 2000		separated from stdmac.uc

#ifndef TIM_UC
#define TIM_UC


// API:
//		tim_delay[_n]
//		tim_sleep[_n, const_use_xfer]



// tim_delay
//		description: delay approx n cycles, don't swap out
//		inputs:
//			_n				constant. cycles to delay
//		size: 6 instr
//		see also: 
//		example usage:
//			tim_delay[20]						; delay 20 cycles		
////
#macro tim_delay[_n]
.local delay_val
	immed[delay_val, _n]
	alu_shf[delay_val, --, B, delay_val, >>2]		; to account for 4 cycles per iteration
	.while (delay_val > 0)
	alu[delay_val, delay_val, -, 1]
	.endw
.endlocal
#endm
// LEGACY pre v1.0
#define delay tim_delay


// tim_sleep
// 		description: sleep for n cycles, let other contests run
//		inputs:
//			_n				constant or GPR. cycles to sleep
//			const_use_xfer	sram read xfer reg to use when reading cycle count
//		size: 12 instr
//		see also: 
//		example usage:
//			tim_sleep[100, X0]						; sleep 100 cycles		
//
#macro tim_sleep[_n, const_use_xfer]
.operand_synonym new_timer diff 

	csr[read, const_use_xfer, CYCLE_CNT], ctx_swap
#if (((isnum (_n)) && (_n > 20)) || (!isnum(_n)))
.local new_timer, saved_timer
	alu[saved_timer, --, B, const_use_xfer, >>2]	; save timer ignore low 2 bits
iterate#:
	csr[read, const_use_xfer, CYCLE_CNT], ctx_swap
	alu[new_timer, --, B, const_use_xfer, >>2]		; new timer ignore low 2 bits	
	.if (new_timer < saved_timer)
		alu[new_timer, new_timer, +, 1, <<30]
	.endif
	alu[diff, new_timer, -, saved_timer]
	.if (diff < _n)
		br[iterate#], defer[1]
		move[saved_timer, new_timer]
	.endif
.endlocal
#endif
#endm


#endif // TIM_UC