//------------------------------------------------------------------------------------
//                                                                      
//                   I N T E L   P R O P R I E T A R Y                   
//                                                                       
//      COPYRIGHT (c)  1998-99 BY  INTEL  CORPORATION.  ALL RIGHTS          
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//      THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                       
//                         INTEL  CORPORATION                            
//                                                                      
//                      2200 MISSION COLLEGE BLVD                        
//                                                                       
//                SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                       
//------------------------------------------------------------------------------------
// rec_ipverify.uc
// IPV4 verify the ip header prior to routing decision
//
//
// system: SA1200
// subsystem: IP route microcode
// usage: example
// author: dfh 11/8/97
//	
// revisions:
//		dfh		1/12/99		bi-endian. lower level macros perform swaps if #define LITTLE_ENDIAN
//		dfh		3/31/00		use ip.uc macros
//
// ---------------------------SA1200 microcode--------------------------	

 

// Prerequisite: 
//	rec_nextpac.uc   has executed
//	first 4 longwords of the packet has been read in from reveive FIFO
//

//	register usage at this point
//
//	$xfer0 					MAC DA<31:0>
//	$xfer1					MAC  DA<48:32> and SA<15:0> 
//	$xfer2					MAC  SA<31:0>  
//	$xfer3					MAC length and ip version, IHL, TOS
//	protocol_len			datalink payload length
//	packet_buf_addr			address of buffer in sdram where packet will be stored
//	buf_handle				address offset of the current descriptor
//	rec_state				fastport flag, packet sequence number, byte enables, eop, sop

// 
#include "ip.uc"								; ip macros

#macro	ip_checksum_extract[_ip_cs, const_srbuf_ip_start]
	field_srbuf_extract[_ip_cs, const_srbuf_ip_start, 10, 11]
#endm


// encrypt/decrypt
#macro endecrypt[output, input, key]
   alu[output, input, XOR, key]
//   alu[output, output, XOR, key]
//   alu[output, output, XOR, key]
#endm

// esp header begins at byte 2 after transferring from rfifo
#macro esp_spi_extract[_esp_spi, const_srbuf_esp_start]
	field_srbuf_extract[_esp_spi, const_srbuf_esp_start, 0, 3]
#endm

#macro esp_seq_extract[_esp_seq, const_srbuf_esp_start]
	field_srbuf_extract[_esp_seq, const_srbuf_esp_start, 4, 7]
#endm

#macro esp_nexthdr_extract[_esp_nexthdr, const_srbuf_esp_start]
	field_srbuf_extract[_esp_nexthdr, const_srbuf_esp_start, 8, 8]
#endm

// lookup policy table
// input: ip_sa
// return
//    br=cout not found
//    =0 found
#macro lookup_policy[_ip_sa, const_sram_policy_addr]
.local table_base offset
   immed32[table_base, const_sram_policy_addr]
   immed[offset, 0]
   immed[exception, NO_ERROR]

start_policy_lookup#:
   sram[read, $xfer0, table_base, offset, 1], ctx_swap
   alu[--, $xfer0, -, _ip_sa]
   br=0[end#], defer[2]
   nop
   nop
   alu[--, 1, +, $xfer0]
   br=0[end#], defer[2]
   immed[exception, POLICY_NOTFOUND]
   nop
   alu[offset, offset, +, 1]
   immed[exception, NO_ERROR]
   br[start_policy_lookup#]

end#:
.endlocal
#endm

// lookup sa table
// format of sa table
// |---------------------------------------------------------------|
// |  32-bit   |   32-bit   |   32-bit   |   32-bit   |   32-bit   |
// | dest_ip   | SPI        | tunnel_ip  | seqNo      | key        |
// |---------------------------------------------------------------|
// br=cout (not found)

#macro lookup_sa[_sa_spi, _sa_tunnel_ip, _sa_seq, _sa_key, _ip_da, const_sram_sa_addr]
.local table_base offset
   immed32[table_base, const_sram_sa_addr]
   immed[offset, 0]
   immed[exception, NO_ERROR]

start_sa_lookup#:
   sram[read, $xfer0, table_base, offset, 1],ctx_swap
   alu[--, _ip_da, -, $xfer0]
   br=0[sa_found#], defer[2]
   nop
   nop
   alu[--, 1, +, $xfer0]
   br=cout[end#], defer[2]
   immed[exception, SA_NOTFOUND]
   nop
   alu[offset, offset, +, 5]
   immed[exception, NO_ERROR]
   br[start_sa_lookup#]

sa_found#:
   alu[offset, offset, +, 1]
   sram[read, $xfer0, table_base, offset, 2],ctx_swap
   move[_sa_spi, $xfer0]
   move[_sa_tunnel_ip, $xfer1]
   alu[offset, offset, +, 2]
   sram[read, $xfer0, table_base, offset, 2],ctx_swap
   move[_sa_seq, $xfer0]
   move[_sa_key, $xfer1]

end#:
.endlocal
#endm

#macro lookup_sa_by_spi[_sa_tunnel_ip, _sa_seq, _sa_key, _esp_spi, _ip_da, const_sram_sa_addr]
.local table_base offset
   immed32[table_base, const_sram_sa_addr]
   immed[offset, 0]
   immed[exception, NO_ERROR]

start_sa_lookup#:
   sram[read, $xfer0, table_base, offset, 1],ctx_swap
   alu[--, _ip_da, -, $xfer0]
   br=0[sa_ip_found#], defer[2]
   nop
   nop
   alu[--, 1, +, $xfer0]
   br=cout[end#],defer[2]
   immed[exception, SA_NOTFOUND]
   nop
   alu[offset, offset, +, 5]
   immed[exception, NO_ERROR]
   br[start_sa_lookup#]

sa_ip_found#:
   alu[offset, offset, +, 1]
   sram[read, $xfer0, table_base, offset, 1],ctx_swap
   alu[--, _esp_spi, -, $xfer0]
   br=0[sa_found#]
   alu[offset, offset, +, 4]
   br[start_sa_lookup#]

sa_found#:
   alu[offset, offset, +, 1]
   sram[read, $xfer0, table_base, offset, 2],ctx_swap
   move[_sa_tunnel_ip, $xfer0]
   move[_sa_seq, $xfer1]
   alu[offset, offset, +, 2]
   sram[read, $xfer0, table_base, offset, 1],ctx_swap
   move[_sa_key, $xfer0]

end#:
.endlocal
#endm


ip_verify#:

.local /*sa01*/ sa_spi sa_tunnel_ip sa_seq /*sa_key*/

// move second 4 quadwords of receive fifo element to sdram 
//

// tlaw -- what are these 4 quadwords in SDRAM??
//         transfer 4 quadwords from from rfifo_entry+4 to packet_buf_addr+4
//	sdram_r_fifo_rd[packet_buf_addr, rfifo_entry, 4, 4, ASYNC]		; (see stdmac.uc)

// tlaw Oct 23, start transfer later.
//    sdram_rfifo_read[packet_buf_addr, 8, rfifo_entry, 4, 4, ASYNC]

// tlaw -- use sdram_rfifo_read instead of sdram_r_fifo_rd

// sdram_rfifo_read
// [_sd_qw_addr, _sd_offset, _rfifo_base_addr, const_rfifo_offset, qw_count, sig_spec]
// 		description: Copy 1-16 quadwords from rfifo(base+offset) to sdram.
//		outputs:
//		inputs:
//			_sd_qw_addr			starting quadword address at sdram
//			_rfifo_base_addr	quadword base address to be added to form rfifo address
//			const_rfifo_offset	quadword offset to be added to form rfifo address
//			qw_count			GPR or constant. number of quadwords to write
//			sig_spec			pend:  waiting on signal, context swap
//								sig:   requesting signal, but continuing
//								nosig: not requesting signal, continuing
//		size: 1-5 instr


read_rfifo2#:
// get the next 6 longwords of the packet from the receive FIFO
// continuing from where layer 2 left off, and wrapping
//

// tlaw -- $xfer4, $xfer5, $xfer6, $xfer7 are occupied.
    r_fifo_rd[$xfer4, rfifo_entry, 2, 2]


// tlaw -- save old header into sdram

   move[$$xfer0, $xfer0]
   move[$$xfer1, $xfer1]
   move[$$xfer2, $xfer2]
   move[$$xfer3, $xfer3]
   sdram[write, $$xfer0, packet_buf_addr, 0, 2], ctx_swap

// tlaw -- stores MAC SA<15:0> into sa01
/*
#ifdef LITTLE_ENDIAN
	alu[sa01, 0, +16, $xfer1, >>16]
#else
	alu[sa01, 0, +16, $xfer1]										; save sa bytes 0-1 for later merge
#endif
*/
    r_fifo_rd[$xfer0, rfifo_entry, 4, 1], ctx_swap
    

// tlaw --
// ip_verify
//		description: Verify ip total length, time-to live and checksum.
//			note: ip header halfword READ_ALIGNs only are supported
//		outputs:
//			exception				0 if no exception, otherwise ip exception code	
//		inputs:
//			const_srbuf_ip_start	constant start byte of ip header at sram read xfer registers
//									the header can wrap from physical xfer 7 to physical xfer 0					
//		size: 22-26 instr
//		latency: 19-23 instr
//		see also: rec.h(ip exception codes), stdmac.uc, endian.uc
//		example usage:
//			ip_verify[exception, 14]		; ip header starts at sram read xfer byte 14
//
	ip_verify[exception, 14]					; ip header starts at byte 14
	br>0[packet_discard#]
	ctx_arb[voluntary]
	ip_modify[14, 14]
ip_ok#:

// IP Version, IHL, ToS are erased from read $xfer
//.local saved_xfer2 saved_xfer3
//    move[saved_xfer2, $xfer2]
//	move[saved_xfer3, $xfer3]
    r_fifo_rd[$xfer2, rfifo_entry, 5, 1], ctx_swap
//.endlocal

// tlaw - Nov 16, 2000
// load IP fields before classifier
   ip_prot_extract[ip_prot, BYTEOFFSET14]
   ip_da_extract[ip_da, BYTEOFFSET14]
   ip_sa_extract[ip_sa, BYTEOFFSET14]

   esp_spi_extract[sa_spi, BYTEOFFSET2]

// tlaw Oct 23, 2000
// After verification of IP header,
// classify packets

// - classify packets
//   {
//      check protocol field in IP header
//      if ESP (50)
//	     goto process ESP packet
//      else {
//	     get source IP address
//		 look up policy table
//		    (policy table has a list of source IP addr that allow to use IPsec)
//         if source address found
//		    goto create ESP packet
//		 else
//		    goto normal packet
//      }
//   }

#define PKT_LABEL_NORMAL	0
#define PKT_LABEL_INBOUND	1
#define PKT_LABEL_OUTBOUND	2

#define SRAM_SAB_START_ADDR 0x60000
#define SRAM_PD_START_ADDR 0x65001

//.import_var policy_table_base sa_table_base

classifier#:

   .if (ip_prot == 50)
      br[pkt_from_tunnel#], defer[1]
      immed[pkt_label, PKT_LABEL_INBOUND]
   .endif
   
   lookup_policy[ip_sa, SRAM_PD_START_ADDR]
   .if (exception == POLICY_NOTFOUND)
      br[start_transfer#], defer[1]   ; if not found, normal packet
      immed[pkt_label, PKT_LABEL_NORMAL]
   .endif

pkt_to_tunnel#:

   lookup_sa[sa_spi, sa_tunnel_ip, sa_seq, sa_key, ip_da, SRAM_SAB_START_ADDR]
   .if ( exception == SA_NOTFOUND )
      br[packet_discard#]
   .endif
   br[start_transfer#], defer[1]
   // ip_sa found in policy table
   // sa found in sa table, create ESP
   immed[pkt_label, PKT_LABEL_OUTBOUND]


// - process ESP packet
//   {
//      get dest IP address
//	  get SPI from ESP
//	  lookup SA table
//	  if found
//	     verify ESP header
//		    seqNo
//			nextHeader
//         if OK, update seqNo in table
//		    start transfer of inner IP packet to SDRAM
//      else
//	     discard
//      decrypt whole inner IP packet
//   }
pkt_from_tunnel#:
// tlaw Oct 30, 2000 don't verify seqNo for now
//   esp_seq_extract[esp_seq, BYTEOFFSET2]
   lookup_sa_by_spi[sa_tunnel_ip, sa_seq, sa_key, sa_spi, ip_da, SRAM_SAB_START_ADDR]
   .if (exception == SA_NOTFOUND)
      br[packet_discard#]
   .endif
// verify ESP header
// update seqNo in SA table

//   br[start_transfer#]


start_transfer#:

.local temp
// store header and transfer
.if (pkt_label == PKT_LABEL_NORMAL)
    move[$$xfer4, $xfer4]
	move[$$xfer5, $xfer5]
	move[$$xfer6, $xfer6]
	move[$$xfer7, $xfer7]
    sdram[write, $$xfer4, packet_buf_addr, 2, 2], ctx_swap		; write first 32 bytes of modified mpacket
   sdram_r_fifo_rd[packet_buf_addr, rfifo_entry, 4, 4, ASYNC]
.elif (pkt_label == PKT_LABEL_OUTBOUND)
    move[$$xfer4, $xfer4]
	move[$$xfer5, $xfer5]
	move[$$xfer6, $xfer6]
	move[$$xfer7, $xfer7]
    sdram[write, $$xfer4, packet_buf_addr, 2, 2], ctx_swap			; write first 32 bytes of modified mpacket

#ifdef USE_ENDECRYPT
   r_fifo_rd[$xfer0, rfifo_entry, 4, 4], ctx_swap
   endecrypt[$$xfer0, $xfer0, sa_key]
   endecrypt[$$xfer1, $xfer1, sa_key]
   endecrypt[$$xfer2, $xfer2, sa_key]
   endecrypt[$$xfer3, $xfer3, sa_key]
   endecrypt[$$xfer4, $xfer4, sa_key]
   endecrypt[$$xfer5, $xfer5, sa_key]
   endecrypt[$$xfer6, $xfer6, sa_key]
   endecrypt[$$xfer7, $xfer7, sa_key]
   sdram[write, $$xfer0, packet_buf_addr, 8, 4], sig_done
#else
   sdram_rfifo_read[packet_buf_addr, 8, rfifo_entry, 4, 4, sig_done]
#endif

.else ; PKT_LABEL_INBOUND

   sdram[read, $$xfer0, packet_buf_addr, 1, 1], ctx_swap

#ifdef USE_ENDECRYPT
   r_fifo_rd[$xfer0, rfifo_entry, 5, 3], ctx_swap
   move[$$xfer0, $$xfer0]
   ld_field[temp, 0011, $xfer1]
   endecrypt[temp, temp, sa_key]
   ld_field[$$xfer1, 0011, temp]
   endecrypt[$$xfer2, $xfer2, sa_key]
   endecrypt[$$xfer3, $xfer3, sa_key]
   endecrypt[$$xfer4, $xfer4, sa_key]
   endecrypt[$$xfer5, $xfer5, sa_key]
   sdram[write, $$xfer0, packet_buf_addr, 1, 3], sig_done
#else
   r_fifo_rd[$xfer0, rfifo_entry, 5, 1], ctx_swap
   move[$$xfer0, $$xfer0]
   ld_field[temp, 0011, $xfer1]
   ld_field[$$xfer1, 0011, temp]
   sdram[write, $$xfer0, packet_buf_addr, 1, 1], ctx_swap
   sdram_rfifo_read[packet_buf_addr, 2, rfifo_entry, 6, 2, sig_done]
#endif

.endif

.endlocal
// - create outer IP header
//   {
//      copy inner IP header
//	  change source address to own IP addr
//	  change dest address to dest IP from SA table
//	  new IHL
//	  total length = inner total length + 20 + 9
//	  new TTL
//	  new protocol (ESP 50)
//	  calculate checksum
//   }

// - create ESP packet
//   {
//      start transfer of IP packet to SDRAM
//      get dest IP address
//	  lookup SA table (use first SA found)
//	  create ESP header
//	     SPI 32-bit
//		 seqNo 32-bit
//		 nextHeader 8-bit (IP 33)
//      write ESP header into SDRAM
//    write inner IP header
//	  create outer IP header
//	  write outer IP header to SDRAM
//	  encrypt whole inner IP packet
//   }
