//------------------------------------------------------------------------------------
//                                                                      
//                   I N T E L   P R O P R I E T A R Y                   
//                                                                       
//      COPYRIGHT (c)  1998-99 BY  INTEL  CORPORATION.  ALL RIGHTS          
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//      THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                       
//                         INTEL  CORPORATION                            
//                                                                      
//                      2200 MISSION COLLEGE BLVD                        
//                                                                       
//                SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                       
//------------------------------------------------------------------------------------
// rec.uc
// top assembler source file to include receive microcode modules, slow and fast ports
//
// Version = 1.0.NoBldNum
//
// system: SA1200
// subsystem: receive microcode
// usage: example
// author: dfh 2/20/98
// revisions:
//		dfh		7/29/98		remove #define REC_SCHEDULER2
//		dfh		1/12/99		use switches FID, NO_ZERO_PROT, NO_BRIDGE, NO_ROUTE
//
//------------------------------------------------------------------------------------

// Assembler switches(defines) summary for rec.uc
//		-D FID=n				FBOX id = n
//		-D F1					FBOX id = 1
//		-D F2					FBOX id = 2
//		-D ZERO_PROTOCOL=n		insert layer 3 zero protocol code
//							(if defined) if mac layer protocol/length field is zero, 
//									forward to output port indicated by first byte of layer 3
//							(if == 1) insert receive control only into packet bytes 36-39
//							(if == 2) insert receive control and status into packet bytes 32-39
//		-D NO_BRIDGE			no bridge code
//		-D NO_ROUTE				no route code
//		-D FAST_PORT1=n			insert fast port code
//		-D REC_STATE_SAVE		save and restore buf_handle and status between threads
//								working on mpackets.
//								use this define in 16 port and fast port versions (not in 12 port)
//		-D LITTLE_ENDIAN		little-endian MAC. perform appropriate swaps in field macros
//		(defaults)				FB0X id = 0, zero prot, bridge, route, no fast port

// receive threads will be threads 0-11

// set thread context thread id(CONTEXT*_TID) based on FBOX ID (FID)
// thread_id is statically bound to rfifo element number
// thread 0 gets element 0, thread 1 get element 1, etc.
// also if thread needs to signal another thread  or send a SHRIMP message
// it will need to use its thread id(values 0-23)
//
// example assembler commands, to optimize and set fbox 0-2:
//		uca -O -D FID=0 -o rec_f_f0.list rec_f
//		uca -O -D FID=1 -o rec_f_f1.list rec_f
//		uca -O -D FID=2 -o rec_f_f2.list ref_f
//
// default (no FID switch) means this code runs on fbox 0 or the context TID is not needed
//
#ifdef F1
#define FID 1
#endif

#ifdef F2
#define FID 2
#endif

#ifdef F3
#define FID 3
#endif

#ifndef FID
#define FID 0
#endif
//
#define_eval CONTEXT0_TID (FID*4)
#define_eval CONTEXT1_TID (FID*4+1)
#define_eval CONTEXT2_TID (FID*4+2)
#define_eval CONTEXT3_TID (FID*4+3)

#if (FID == 0)
.image_name receive0
#elif (FID == 1)
.image_name receive1
#elif (FID == 2)
.image_name receive2
#elif (FID == 3)
.image_name receive3
#endif

#ifdef ALT_BANKS
#define_eval PACKET_FREELIST (~FID & 1)
#else
#define PACKET_FREELIST 0
#endif

// cause insertion of bridge code
//
// example asembler command, no bridge code
//		uca -O -D FID=0 -D NO_BRIDGE -o rec_f_f0.list rec_f
//
#ifndef NO_BRIDGE
#define BRIDGE
#endif


// cause insertion of ip route code
//
#ifndef NO_ROUTE
#define ROUTE
#endif

// cause insertion of fast port code
//
#define FAST_PORT_ENABLED

#include "rec.h"
#include "mem_map.h"
#include "stdmac.uc"
#include "ixplib.uc"
#include "refdes_macros.uc"

#include "rec_nextpac.uc"
#ifdef BRIDGE
#include "rec_bridge.uc"
#endif
#ifdef ROUTE
#include "rec_ipverify.uc"
#include "rec_lmatch.uc"
#endif
#include "rec_enqueue.uc"

#ifdef BRIDGE
#define HASH_FUNC
#include "stdfunc.uc"
#endif
