//------------------------------------------------------------------------------------
//                                                                     
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  1999-2000 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                      
//-----------------------------------------------------------------------------------
// hw_init.uc
// hardware initializations
//-----------------------------------------------------------------------------------
//
//
// system: SA1200
// subsystem: transmit microcode
// usage: reference design
// author: dfh 12/10/99
// revisions:


#include "mem.uc"			// memory allocation macros


	// EVEN transmit engine does freelist creation and xmit_rdy_ctl setup

#ifdef EVEN
	//
	// setup transmit ready control to identify which thread fbi will auto_push ready bits to
	// xmit_rdy_ctl 
	// +--------+--------+-------+----+---------+-----+----------+
	// |tfifo v |reserved|enab ap|when| pushcmd | sig |thread id |
	// | 31:16  |  15:10 |   9   |  8 |  7:6    |  5  |   4:0    |
	// +--------+--------+-------+----+---------+-----+----------+
	// field		description
	// enab ap		enable autopush
	// when			after xmit_rdybits lo/hi have been assembled
	// pushcmd		xmit_rdybits_lo<31:0> to $xfer1, xmit_ptrs to $xfer0
	// sig			signal
	// thread_id	tx_scheduler

	#ifdef SDRAM_VALIDATE
		immed[$xfer2, 0x800]		; no autopush, sdram validate
	#else
		immed[$xfer2, 0x0]			; no autopush, no sdram validate, no signal on autopush, sched = thread 20
	#endif
	csr [write, $xfer2, xmit_rdy_ctl], ctx_swap


	// write the rdy bus program  
	#ifdef ONLY_GIG_MAC
		immed32[$xfer2, 0x000000d6]								; tx rdy mac 1 == d6. flow control == 0x00
		csr [write, $xfer2, rdybus_template_prog1], ctx_swap
		immed32[$xfer2, 0x00000000]								; flow control (executes faster than nop)
		csr [write, $xfer2, rdybus_template_prog2], ctx_swap
		immed32[$xfer2, 0x00000000]								; flow control (executes faster than nop)
		csr [write, $xfer2, rdybus_template_prog3], ctx_swap
	#else
		immed32[$xfer2, 0x00fb0000]								; rx rdy mac 0 == 0xfb. flow control == 0x00
		csr [write, $xfer2, rdybus_template_prog1], ctx_swap
		immed32[$xfer2, 0x00d70000]								; tx rdy mac 0 and 1 == 0xd7, flow control (executes faster than nop)
		csr [write, $xfer2, rdybus_template_prog2], ctx_swap
		immed32[$xfer2, 0x00000000]								; flow control (executes faster than nop)
		csr [write, $xfer2, rdybus_template_prog3], ctx_swap
	#endif	


	#ifdef RECEIVE16
	// there is no separate rec scheduler, therefore setup rec_rdy_ctl and freelist here
 
	// setup receive ready control to identify which thread fbi will auto_push ready bits to
	//
	// +--------+----------+-------+----+---------+-----+----------+
	// |1thread |push count|enab ap|when| pushcmd | sig |thread id |
	// |  14    |  12:10   |   9   |  8 |  7:6    |  5  |   4:0    |
	// +--------+----------+-------+----+---------+-----+----------+
	// field		value
	// 1thread		0	for fast port put the thread of receive request to receive control
	// push count	3	delay timer for both receive and xmit
	// enab ap		0	enable autopush
	// when			0   after rec_rdycnt has incremented	
	// pushcmd		0	push nothing
	// sig			0	signal
	// thread_id	16	not receive thread, (pushing nothing anyway)
setup_ctl#:
		immed[$xfer2, 0x4c10]					; set rcv_rdy_ctl
		csr [write, $xfer2, rcv_rdy_ctl], ctx_swap 

		immed[$xfer2, 1]						; set rdybus_synch_count_default to min value
		csr[write, $xfer2, rdybus_synch_count_default], ctx_swap

	#endif	// RECEIVE16

	// call	#macro freelist_create[freelist_id, base_addr, stride, count]
	//		initialize freelist 0 for BUFFER_COUNT 2KB_packet_descriptors
	//		see also: mem_map.h, stdmac.uc, stdfunc.uc
	//
	#ifndef BUFFER_COUNT
		#define BUFFER_COUNT FREELIST_BTYPE_SRAM8_SDRAM2K_COUNT
	#endif

	#ifdef ALT_BANKS
	// create freelists 0 and 1 for odd and even banks
		#define_eval HALF_BUFFER_COUNT (BUFFER_COUNT / 2)
		freelist_create[0, SRAM_BUFF_DESCRIPTOR_BASE, 4, HALF_BUFFER_COUNT]
		#define_eval NEXT_BUFF_DESCRIPTOR_BASE (SRAM_BUFF_DESCRIPTOR_BASE + (HALF_BUFFER_COUNT * 4))
		freelist_create[1, NEXT_BUFF_DESCRIPTOR_BASE, 4, HALF_BUFFER_COUNT]
	#else	// not ALT_BANKS
		freelist_create[0, SRAM_BUFF_DESCRIPTOR_BASE, 4, BUFFER_COUNT]
	#endif	//ALT_BANKS not ALT_BANKS

	#ifdef RECEIVE16
freelist_created#:
		fast_wr[0, inter_thd_sig]	; signal receive threads to go
		fast_wr[4, inter_thd_sig]
		fast_wr[8, inter_thd_sig]
		fast_wr[12, inter_thd_sig]
	#else 							; not RECEIVE16
		fast_wr[12, inter_thd_sig]	; signal other rec_scheduler to go
	#endif	// not RECEIVE16
#endif	// EVEN


