CPU	= ARMSA110
TOOL	= gnu

ifneq ($(CCMODE),DEBUG)
DBG_FLAG =
LIB_DIR	= ..\..\VxWorks_Lib
else
DBG_FLAG = -g
LIB_DIR	= ..\..\VxWorks_Lib\debug
endif

LIB	= $(LIB_DIR)\rtm.a
LIB_OBJS = rtm.o rtm_console.o

INCLUDE = \
	-I../../utils \
	-I../../include \
	-I../../BoardSupport/VxWorks/ixp1200eb \
	-I../core_utils \
	-I../msgq

ADDED_C++FLAGS  = -w -Wall -pedantic -DOS=VXWORKS -DIOSTYLE=HARDWARE -DVX_WORKS \
 -D__unix $(INCLUDE)

TGT_DIR=$(WIND_BASE)/target
include $(TGT_DIR)/h/make/defs.bsp
include $(TGT_DIR)/h/make/make.$(CPU)$(TOOL)
include $(TGT_DIR)/h/make/defs.$(WIND_HOST_TYPE)

.SUFFIXES: .o .cpp .c .h .hxx

.cpp.o :
	$(CXX) $(DBG_FLAG) $(C++FLAGS) -c $?
	@ echo ""

.c.o :
	$(CC) $(DBG_FLAG) $(C++FLAGS) -c $?
	@ echo ""

exe : $(LIB)

$(LIB) : $(LIB_OBJS)
	@ if not exist "$(LIB_DIR)/$(NULL)" mkdir "$(LIB_DIR)"
	$(AR) -rc $(LIB) $(LIB_OBJS)

clean	: 
	$(RM) $(LIB_OBJS) $(LIB)

