/* ucld_dbg.h
 * uCode Object File header file
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *  system: SA1200
 *  subsystem: Linker/Loader
 *  author: drj April 17, 98  Initial version
 *  revisions:
 *  $History: uof_dbg.h $
 * 
 * *****************  Version 5  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 4:23p
 * Updated in $/development/ucld
 * update COPYRIGHT
 * 
 * *****************  Version 4  *****************
 * User: Drjohns1     Date: 1/27/99    Time: 2:46p
 * Updated in $/development/ucld
 * Added breakpoint support
 * 
 * *****************  Version 3  *****************
 * User: Drjohns1     Date: 5/21/98    Time: 2:20p
 * Updated in $/base_level2/ucld
 * Updated copyright header
 * 
 * *****************  Version 2  *****************
 * User: Johnsondes   Date: 4/30/98    Time: 2:51p
 * Updated in $/base_level2/ucld
 * Removed extraneous tab from source lines.  Included uof.,h from
 * uof_dbg.h
 * 
 * *****************  Version 1  *****************
 * User: Johnsondes   Date: 4/29/98    Time: 5:25p
 * Created in $/base_level2/ucld
 * Added debug information for WorkBench
 * 
 *
 * ---------------------------------------------------------------------
 */
#ifndef __UOF_DBG_H__
#define __UOF_DBG_H__

#include "uof.h"
#include "utl_crc.h"


typedef enum{
    GPR_A_REL = 0,
    GPR_B_REL,
    GPR_A_ABS,
    GPR_B_ABS,
    SRAM_REL,
    SDRAM_REL,
    SRAM_ABS,
    SDRAM_ABS
}Ucld_RegType;

#define DBG_OBJS	"DBG_OBJS"
#define DBG_IMAG	"DBG_IMAG"
#define DBG_STRT	"DBG_STRT"

typedef uof_strTab_T	dbg_strTab;
typedef uof_chunkHdr_T	dbg_chunkHdr_T;


typedef struct dbg_Image_S{
   int			imageName;			/* list file name str-table offset */
   short		imageAttrib;		/* image attributes */
   short		regTabSize;			/* registers table size */
   short		lblTabSize;			/* labels table size */
   short		srcTabSize;			/* source lines table size */
   int			regTabOffset;		/* registers table offset */
   int			lblTabOffset;		/* labels table offset */
   int			srcTabOffset;		/* source lines table offset */
}dbg_Image_T;


typedef struct dbg_ObjTable_S{
   short		numEntries;			/* num of entries in table */
   short		unused1;			/* reserved/alignment */
   /* numEntries * sizeof(element) follows */
}dgb_ObjTable_T;

typedef dgb_ObjTable_T dbg_RegTab_T;
typedef dgb_ObjTable_T dbg_LblTab_T;
typedef dgb_ObjTable_T dbg_SrcTab_T;


typedef struct dbg_Reg_S{
   int			name;				/* reg name string-table offset */
   short		type;				/* reg type */
   short		addr;				/* reg address */
}dbg_Reg_T;

typedef struct dbg_Label_S{
   int			name;				/* label name string-table offset */
   short		addr;				/* label address */
   short		unused1;			/* reserved/alignment */
}dbg_Label_T;

typedef struct dbg_Source_S{
   int			fileName;			/* source file name */
   int			lines;				/* source lines str-table offset */
   short		lineNum;			/* source line number */
   short		addr;				/* associated micro address */
   short		validBkPt;			/* valid breakpoint indicator */
   short		unused1;			/* reserved/alignment */
}dbg_Source_T;
#endif			// __UOF_DBG_H__
