/* thread.h
 * Thread utility
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *  system: SA1200
 *  subsystem: Common
 *  author: sk/drj Feb 27, 98  Initial version
 *  revisions:
 *  $History: thread.h $
 * 
 * *****************  Version 20  *****************
 * User: Drjohns1     Date: 4/04/00    Time: 6:46p
 * Updated in $/dev_1200/Include
 * OS type check and cleanup
 * 
 * ---------------------------------------------------------------------
 */

#ifndef __THREAD_H
#define __THREAD_H

#include "ostype.h"


#if (OS == WIN_32)
#include <wtypes.h>
#include <winbase.h>

typedef HANDLE thread_T;
#define LOW_PRIORITY THREAD_PRIORITY_LOWEST
#define HIGH_PRIORITY THREAD_PRIORITY_HIGHEST
#define MID_PRIORITY THREAD_PRIORITY_NORMAL
#endif	                        /* WIN32 */

#if (OS == UCOS)
#include "os.h"
typedef int thread_T;

extern int getNextUniqueTaskID(void);

/* priority stuff are not used in uCOS */
#define HIGH_PRIORITY  0
#define LOW_PRIORITY   63
#define MID_PRIORITY  (LOW_PRIORITY + HIGH_PRIORITY)/2
#endif				/* UCOS */


#if (OS == VXWORKS)
#include <taskLib.h>
typedef int thread_T;
#define HIGH_PRIORITY  0
#define LOW_PRIORITY   255
#define MID_PRIORITY  (LOW_PRIORITY + HIGH_PRIORITY)/2
#endif				/* VXWORKS */


#if (OS == UNIX) 
#include <pthread.h>
typedef pthread_t thread_T;
typedef void  *(*pthread_startroutine_t) (void *);
typedef void  *pthread_addr_t;

#if defined(__sun)
#define HIGH_PRIORITY  -41
#define LOW_PRIORITY   -100
#endif

#if defined(__linux__)
#define HIGH_PRIORITY  99
#define LOW_PRIORITY   1
#endif

#if defined(__DECC) || defined(__DECCXX)
#define HIGH_PRIORITY  PRI_OTHER_MAX
#define LOW_PRIORITY   PRI_OTHER_MIN
#endif

#define MID_PRIORITY  (LOW_PRIORITY + HIGH_PRIORITY)/2
#endif				/* UNIX */

typedef void threadArg_T;
typedef void (*threadFunc_T)(void *);

#ifdef __cplusplus
extern "C"{
#endif

thread_T Thread_Create(int priority, void (*startFunc)(threadArg_T *), threadArg_T *arg);
int Thread_Cancel(thread_T thread);
int Thread_SetPriority(thread_T, int priority);
#ifdef __cplusplus
}
#endif

#endif /* __THREAD_H */

