/* sram_man.h
 * SA1200 Hardware Absraction Library -- SRAM Manager
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *
 *  system: SA1200
 *  subsystem: SRAM
 *  author: dfh, Mar 4,99  Initial version
 *  revisions:
 *  $History: sram_man.h $
 * 
 * *****************  Version 12  *****************
 * User: Dmwhite      Date: 4/05/00    Time: 4:37p
 * Updated in $/dev_1200/Include
 * took out some unwanted comments
 * 
 * *****************  Version 8  *****************
 * User: Dhooper      Date: 6/09/99    Time: 5:41p
 * Updated in $/dev_1200/Include
 * extern Scratch_BZero
 * 
 * *****************  Version 7  *****************
 * User: Dhooper      Date: 6/02/99    Time: 4:27p
 * Updated in $/dev_1200/Include
 * add SRAM_BZero, Scratch_BZero
 * 
 * *****************  Version 6  *****************
 * User: Dhooper      Date: 5/13/99    Time: 11:25a
 * Updated in $/dev_1200/Include
 * add sram member variable
 * 
 * *****************  Version 5  *****************
 * User: Dhooper      Date: 5/11/99    Time: 5:26p
 * Updated in $/dev_1200/Include
 * don't extern sram
 * 
 * *****************  Version 4  *****************
 * User: Dhooper      Date: 5/11/99    Time: 9:37a
 * Updated in $/dev_1200/SA1_CoreLibs/hal_1200
 * add UCODE_QUEUES_MASK
 * 
 * *****************  Version 2  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 3:41p
 * Updated in $/development/hal_1200
 * update COPYRIGHT
 * 
 * *****************  Version 1  *****************
 * User: Dhooper      Date: 3/04/99    Time: 11:22a
 * Created in $/development/hal_1200
 * sram manager, push pop freelist
 * 
 * ---------------------------------------------------------------------
 */
#ifndef __SRAM_MAN_H
#define __SRAM_MAN_H


#include "hal_sram.h"

enum SramManReturns{
	SF_SUCCESS = 1,
	SF_Q_NOT_EXIST = -2,
	SF_Q_PREV_INIT = -3,
	SF_Q_UCODE_INIT = -4
};

enum SramQueueParams{
	SF_MAX_QUEUES = 8
};


#ifdef __cplusplus



class SFreeList{
public:
	SFreeList();
	~SFreeList(){}

	int init(unsigned char id, unsigned int base, unsigned int chunk_size, unsigned int qty);

	unsigned int alloc(unsigned char id);

	void free(unsigned char id, unsigned int ptr);

private:
	SramUnit *sram;
	unsigned int init_vector;
};

#endif		// __cplusplus

extern void SRAM_BZero(int loc, int len);
extern void Scratch_BZero(int loc, int len);

#endif		// SRAM_MAN_H, leave next blank line in
