/* rs_udbg_lib.h
 * Remote Ucode Debug Library Application Interface
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *
 *  system: SA1200
 *  subsystem: Debug Library
 *  author: lwh, 12/2/98  Initial version
 *  revisions:
 *  $History: rs_udbg_lib.h $
 * 
 * *****************  Version 35  *****************
 * User: Lhui         Date: 10/19/99   Time: 5:15p
 * Updated in $/dev_1200/Include
 * add support for uDbg_GetSysMemSize
 * 
 * *****************  Version 34  *****************
 * User: Lhui         Date: 10/04/99   Time: 4:33p
 * Updated in $/dev_1200/Include
 * Add support for the enhanced dbg_reset API
 * 
 * *****************  Version 33  *****************
 * User: Rdmurato     Date: 9/30/99    Time: 12:52p
 * Updated in $/dev_1200/Include
 * Add prototypes for new fifo read/write functions
 * 
 * *****************  Version 31  *****************
 * User: Lhui         Date: 7/16/99    Time: 4:14p
 * Updated in $/dev_1200/Include
 * Add support for uDbg_UpdateFreeUstore & uDbg_DefineFreeUstore
 * 
 * *****************  Version 30  *****************
 * User: Lhui         Date: 6/29/99    Time: 7:18p
 * Updated in $/dev_1200/Include
 * Add support for uDbg_ClrReset
 * 
 * *****************  Version 29  *****************
 * User: Lhui         Date: 6/18/99    Time: 6:26p
 * Updated in $/dev_1200/Include
 * Update Control API
 * 
 * *****************  Version 27  *****************
 * User: Lhui         Date: 4/22/99    Time: 5:42p
 * Updated in $/development/rs_udebug
 * Add a delay parameter to  rs_udebug/control  hop functions. 
 * 
 * *****************  Version 26  *****************
 * User: Lhui         Date: 4/08/99    Time: 5:51p
 * Updated in $/development/rs_udebug
 * Change rs_cntl_pause prototypes
 * 
 * *****************  Version 25  *****************
 * User: Lhui         Date: 4/07/99    Time: 5:08p
 * Updated in $/development/rs_udebug
 * Fix bugs in rs_uDbg_GetUengPCs and rs_uDbg_InitLib 
 * 
 * *****************  Version 24  *****************
 * User: Lhui         Date: 3/29/99    Time: 6:04p
 * Updated in $/development/rs_udebug
 * Add supports for debug control functions (start & hop)
 * 
 * *****************  Version 23  *****************
 * User: Lhui         Date: 3/23/99    Time: 6:37p
 * Updated in $/development/rs_udebug
 * Code cleanup and bug fixing
 * 
 * *****************  Version 22  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 3:48p
 * Updated in $/development/rs_udebug
 * update COPYRIGHT
 * 
 * *****************  Version 21  *****************
 * User: Qabuild      Date: 3/19/99    Time: 4:12p
 * Updated in $/development/rs_udebug
 * update makefile dependencies
 * 
 * *****************  Version 20  *****************
 * User: Lhui         Date: 3/19/99    Time: 1:17p
 * Updated in $/development/rs_udebug
 * Add supports for Scomm.lib
 * 
 * *****************  Version 19  *****************
 * User: Lhui         Date: 3/18/99    Time: 5:51p
 * Updated in $/development/rs_udebug
 * Add supports for SA1200 debug control functions
 * 
 * *****************  Version 18  *****************
 * User: Qabuild      Date: 3/16/99    Time: 4:31p
 * Updated in $/development/rs_udebug
 * Add VxWork supports
 * 
 * *****************  Version 17  *****************
 * User: Lhui         Date: 3/15/99    Time: 3:53p
 * Updated in $/development/rs_udebug
 * Increase the timeout value 
 * 
 * *****************  Version 16  *****************
 * User: Lhui         Date: 3/15/99    Time: 12:06p
 * Updated in $/development/rs_udebug
 * Create a DLL version of rs_udbg_client
 * 
 * *****************  Version 15  *****************
 * User: Lhui         Date: 3/12/99    Time: 2:04p
 * Updated in $/development/rs_udebug
 * Create an  include file for external interface
 * 
 * *****************  Version 14  *****************
 * User: Lhui         Date: 3/09/99    Time: 6:23p
 * Updated in $/development/rs_udebug
 * bug fixing
 * 
 * *****************  Version 13  *****************
 * User: Lhui         Date: 3/01/99    Time: 8:42p
 * Updated in $/development/rs_udebug
 * Fix prototypes
 * 
 * *****************  Version 12  *****************
 * User: Lhui         Date: 2/25/99    Time: 8:52p
 * Updated in $/development/rs_udebug
 * Updated for the latest version of udebug related changes
 * 
 * *****************  Version 11  *****************
 * User: Lhui         Date: 2/22/99    Time: 7:51p
 * Updated in $/development/rs_udebug
 * Add supports for multiple Core components
 * 
 * *****************  Version 10  *****************
 * User: Lhui         Date: 1/29/99    Time: 6:10p
 * Updated in $/development/rs_udebug
 * Add support for VxWorks
 * 
 * *****************  Version 9  *****************
 * User: Lhui         Date: 1/28/99    Time: 6:22p
 * Updated in $/development/rs_udebug
 * Add supports for "C" interface and new udebug functions
 * 
 * *****************  Version 8  *****************
 * User: Lhui         Date: 1/19/99    Time: 5:35p
 * Updated in $/development/rs_udebug
 * update for udebug Get/SetCSR prototype
 * 
 * *****************  Version 7  *****************
 * User: Lhui         Date: 12/18/98   Time: 5:23p
 * Updated in $/development/rs_udebug
 * Fix bugs
 * 
 * *****************  Version 6  *****************
 * User: Lhui         Date: 12/09/98   Time: 7:17p
 * Updated in $/development/rs_udebug
 * Modify udebug calls to reflect udebug's API changes
 * 
 * *****************  Version 5  *****************
 * User: Lhui         Date: 12/07/98   Time: 3:04p
 * Updated in $/development/rs_udebug
 * Fix misc. bugs
 * 
 * *****************  Version 4  *****************
 * User: Lhui         Date: 12/03/98   Time: 10:18p
 * Updated in $/development/rs_udebug
 * fix bugs
 * 
 * *****************  Version 2  *****************
 * User: Lhui         Date: 12/03/98   Time: 5:49p
 * Updated in $/users/Hui/SA-1200/rs_udebug
 * Move files to development area
 * 
 * *****************  Version 1  *****************
 * User: Lhui         Date: 12/03/98   Time: 1:56p
 * Created in $/users/Hui/SA-1200/rs_udebug
 */
#ifndef __RS_UDBG_LIB_H
#define __RS_UDBG_LIB_H

#include "rs_connection.h"
#include "debug_1200.h"
#ifdef RS_UDBG_DLL
#define RS_uDbgAPI_NORET __declspec(dllexport)
#define	RS_uDbgAPI	__declspec(dllexport) int __cdecl
#else
#ifdef WIN32
#define RS_uDbgAPI_NORET __declspec(dllimport)
#define	RS_uDbgAPI	__declspec(dllimport) int __cdecl
#else
#define RS_uDbgAPI_NORET  int
#define	RS_uDbgAPI int
#endif
#endif


#ifdef __cplusplus
extern "C" {
#endif

RS_uDbgAPI RS_uDbg_InitLib(hRS_Conn_T hTarget,uDbg_uStoreFree_T *uStoreFree);
RS_uDbgAPI RS_uDbg_DeleLib(hRS_Conn_T hTarget);
RS_uDbgAPI RS_uDbg_DefineFreeUstore(hRS_Conn_T hTarget, unsigned int uEngMask, 
						   unsigned int freeUaddr, unsigned int freeSize);
RS_uDbgAPI RS_uDbg_UpdateFreeUstore(hRS_Conn_T hTarget, unsigned int uEngMask);
RS_uDbgAPI RS_uDbg_ResetUeng(hRS_Conn_T hTarget, unsigned int uEngMask,int clrReg);
RS_uDbgAPI RS_uDbg_ClrResetUeng(hRS_Conn_T hTarget, unsigned int uEngMask);
RS_uDbgAPI RS_uDbg_StartUeng(hRS_Conn_T hTarget, unsigned int uEngMask);
RS_uDbgAPI RS_uDbg_PauseUeng(hRS_Conn_T hTarget, unsigned int uEngMask, unsigned int delay);
RS_uDbgAPI RS_uDbg_ResumeUeng(hRS_Conn_T hTarget, unsigned int uEngMask);
RS_uDbgAPI RS_uDbg_IsUengActive(hRS_Conn_T hTarget, unsigned int uEngMask);
RS_uDbgAPI RS_uDbg_GetActiveUengs(hRS_Conn_T hTarget, unsigned int uEngMask);

RS_uDbgAPI RS_uDbg_SetUthreadsPC(hRS_Conn_T hTarget, unsigned int uEngMask, unsigned int ctxMask, unsigned int upc);
RS_uDbgAPI RS_uDbg_GetUthreadPC(hRS_Conn_T hTarget, unsigned char uEng, unsigned char ctx, unsigned int *pc);
RS_uDbgAPI RS_uDbg_SetUengPCs(hRS_Conn_T hTarget,unsigned char uEng, unsigned int *upc);
RS_uDbgAPI RS_uDbg_GetUengPCs(hRS_Conn_T hTarget, unsigned char uEng, unsigned int *upc);

RS_uDbgAPI RS_uDbg_SetUword(hRS_Conn_T hTarget, unsigned int uEngMask, unsigned int uWordAddr, unsigned int uWord);
RS_uDbgAPI RS_uDbg_GetUword(hRS_Conn_T hTarget, unsigned int uEng, unsigned int uWordAddr, unsigned int *uWord);
RS_uDbgAPI RS_uDbg_SetNumUword(hRS_Conn_T hTarget, unsigned int uEngMask, unsigned int uWordAddr,
					 unsigned short numWords, unsigned int *uWord);
RS_uDbgAPI RS_uDbg_GetNumUword(hRS_Conn_T hTarget, unsigned int uEngMask, unsigned int uWordAddr,unsigned short numWords, unsigned int *uWord);

RS_uDbgAPI RS_uDbg_WriteMem32(hRS_Conn_T hTarget, unsigned int addr, unsigned int *data, unsigned int count);
RS_uDbgAPI RS_uDbg_ReadMem32(hRS_Conn_T hTarget, unsigned int addr, unsigned int *data, unsigned int count);
RS_uDbgAPI RS_uDbg_WriteMem64(hRS_Conn_T hTarget, unsigned int addr, unsigned int *data, unsigned int count);
RS_uDbgAPI RS_uDbg_ReadMem64(hRS_Conn_T hTarget, unsigned int addr, unsigned int *data, unsigned int count);

RS_uDbgAPI RS_uDbg_SetBreakpoint(hRS_Conn_T hTarget, uDbg_Bkpt_T *breakpoint);
//RS_uDbgAPI RS_uDbg_Continue(hRS_Conn_T hTarget, unsigned short breakpointId);
RS_uDbgAPI RS_uDbg_ShowBreakpoints(hRS_Conn_T hTarget, unsigned int uEng, uDbg_BkptArray_T *breakpoints);
RS_uDbgAPI RS_uDbg_ClearBreakpoint(hRS_Conn_T hTarget, unsigned int breakpointId);
RS_uDbgAPI RS_uDbg_ClearAllBreakpoints(hRS_Conn_T hTarget, unsigned int uEngMask);

RS_uDbgAPI RS_uDbg_SetCSR (hRS_Conn_T hTarget, unsigned int csr, unsigned int data);
RS_uDbgAPI RS_uDbg_GetCSR (hRS_Conn_T hTarget, unsigned int csr, unsigned int *data);

RS_uDbgAPI RS_uDbg_PutRelGPR(hRS_Conn_T hTarget, char uEng, unsigned char ctx,
				   uDbg_Bank_T bankType, unsigned int regNum,
				   unsigned int *regData, unsigned int count);

RS_uDbgAPI RS_uDbg_GetRelGPR(hRS_Conn_T hTarget, char uEng, unsigned char ctx,
				   uDbg_Bank_T bankType, unsigned int regNum,
				   unsigned int *regData, unsigned int count);

RS_uDbgAPI RS_uDbg_PutRelSRAM_WrXfer(hRS_Conn_T hTarget, char uEng, unsigned char ctx, unsigned int regAddr,
						   unsigned int *regData, unsigned int count);

RS_uDbgAPI RS_uDbg_GetRelSRAM_WrXfer(hRS_Conn_T hTarget, char uEng, unsigned char ctx, unsigned int regAddr,
						   unsigned int *regData, unsigned int count);

RS_uDbgAPI RS_uDbg_PutRelSRAM_RdXfer(hRS_Conn_T hTarget, char uEng, unsigned char ctx, unsigned int regAddr,
						   unsigned int *regData, unsigned int count);

RS_uDbgAPI RS_uDbg_GetRelSRAM_RdXfer(hRS_Conn_T hTarget, char uEng, unsigned char ctx, unsigned int regAddr,
						   unsigned int *regData, unsigned int count);

RS_uDbgAPI RS_uDbg_PutRelSDRAM_WrXfer(hRS_Conn_T hTarget, char uEng, unsigned char ctx, unsigned int regAddr,
							unsigned int *regData, unsigned int count);

RS_uDbgAPI RS_uDbg_GetRelSDRAM_WrXfer(hRS_Conn_T hTarget, char uEng, unsigned char ctx, unsigned int regAddr,
							unsigned int *regData, unsigned int count);

RS_uDbgAPI RS_uDbg_PutRelSDRAM_RdXfer(hRS_Conn_T hTarget, char uEng, unsigned char ctx, unsigned int regAddr,
							unsigned int *regData, unsigned int count);

RS_uDbgAPI RS_uDbg_GetRelSDRAM_RdXfer(hRS_Conn_T hTarget, char uEng, unsigned char ctx, unsigned int regAddr,
							unsigned int *regData, unsigned int count);
RS_uDbgAPI RS_uDbg_WriteFIFO_Tx(hRS_Conn_T hTarget, unsigned char uEng, unsigned int fifoAddr, 
                                unsigned int *data64, unsigned int count, int setValid);
RS_uDbgAPI RS_uDbg_ReadFIFO_Rx(hRS_Conn_T hTarget, unsigned char uEng, unsigned int fifoAddr, 
                               unsigned int *data64, unsigned int count);

RS_uDbgAPI RS_uDbg_GetUengStatus(hRS_Conn_T hTarget, unsigned char uEng, uDbg_uEngStatus_T *uEngStatus);
RS_uDbgAPI RS_uDbg_HopUeng(hRS_Conn_T hTarget, unsigned int *uEngMask, unsigned int delay);
RS_uDbgAPI RS_CNTL_InitUof(hRS_Conn_T hTarget, char* buf, int buflen);
RS_uDbgAPI RS_uDbg_GetSysMemSize(hRS_Conn_T hTarget, unsigned int* sys, unsigned int* sys_all, unsigned int* sdram,unsigned int* sram, unsigned int* flash);

RS_uDbgAPI RS_CNTL_Reset(hRS_Conn_T hTarget, unsigned int engineMask, unsigned int portMask,int clrReg);
RS_uDbgAPI RS_CNTL_Pause(hRS_Conn_T hTarget, unsigned int engineMask, unsigned int portMask,unsigned int delay);
RS_uDbgAPI RS_CNTL_Resume(hRS_Conn_T hTarget, unsigned int engineMask,unsigned int portMask);
RS_uDbgAPI RS_CNTL_Start(hRS_Conn_T hTarget, unsigned int engineMask,unsigned int portMask);
RS_uDbgAPI RS_CNTL_Hop(hRS_Conn_T hTarget, unsigned int *engineMask, unsigned int portMask, unsigned int delay);

#ifdef SIM_MODE
RS_uDbgAPI RS_XactCommand(hRS_Conn_T hTarget, char *command);
#endif

#define RS_uDbg_ResetAll() RS_uDbg_Reset(UDEBUG_CTX_ALL)

#ifdef __cplusplus
}
#endif

#endif			/* __UDBG_LIB_H */
