/* hal_sram.h
 * SA1200 Hardware Absraction Library -- SRAM Unit
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *
 *  system: SA1200
 *  subsystem: Debug Library
 *  author: dfh, Feb 24,99  Initial version
 *  revisions:
 *  $History: hal_sram.h $
 * 
 * *****************  Version 25  *****************
 * User: Lhui         Date: 4/18/00    Time: 6:10p
 * Updated in $/dev_1200/Include
 * Merge with IAL source - 4/12/2000 
 * 
 * *****************  Version 1  *****************
 * User: Qabuild      Date: 4/18/00    Time: 5:45p
 * Created in $/Bigpine/SDKChanges/Include
 * added from IAL zip file 4/12/00
 * 
 * *****************  Version 23  *****************
 * User: Drjohns1     Date: 2/29/00    Time: 1:15p
 * Updated in $/dev_1200/Include
 * Made "C" compatable
 * 
 * *****************  Version 22  *****************
 * User: Dmwhite      Date: 2/29/00    Time: 7:57a
 * Updated in $/dev_1200/Include
 * psos ARM compile  switch -pedantic wants <CRLF> before<EOF>
 * 
 * *****************  Version 20  *****************
 * User: Drjohns1     Date: 10/28/99   Time: 3:19p
 * Updated in $/dev_1200/Include
 * Fixed memory offset problem in read_lock and write_unlock
 * 
 * *****************  Version 19  *****************
 * User: Drjohns1     Date: 10/27/99   Time: 1:00p
 * Updated in $/dev_1200/Include
 * Fixed SRAM_WRITE and SRAM_READ macros
 * 
 * *****************  Version 18  *****************
 * User: Dhooper      Date: 10/18/99   Time: 1:12p
 * Updated in $/dev_1200/Include
 * add read_lock and write_unlock per customer request
 * 
 * *****************  Version 16  *****************
 * User: Dhooper      Date: 6/07/99    Time: 7:23p
 * Updated in $/dev_1200/Include
 * define SRAM_CSR_BASE if prevuously not defined, use (unsigned_int) for
 * cast
 * 
 * *****************  Version 15  *****************
 * User: Dhooper      Date: 5/14/99    Time: 9:26a
 * Updated in $/BL5_Plus/Include
 * change SRAM, SDRAM, FBI_Init to *_Attach
 * 
 * *****************  Version 14  *****************
 * User: Dhooper      Date: 5/12/99    Time: 12:48p
 * Updated in $/dev_1200/Include
 * update to match programmer's ref spec as of 5/10/99
 * 
 * *****************  Version 13  *****************
 * User: Dhooper      Date: 5/12/99    Time: 9:52a
 * Updated in $/dev_1200/Include
 * remove sram returns enum
 * 
 * *****************  Version 12  *****************
 * User: Dhooper      Date: 5/11/99    Time: 5:25p
 * Updated in $/dev_1200/Include
 * enforce IOSTYLE FARDWARE or AMBAIO for CSR access
 * 
 * *****************  Version 11  *****************
 * User: Dhooper      Date: 5/11/99    Time: 12:19p
 * Updated in $/dev_1200/Include
 * include iostyle
 * 
 * *****************  Version 10  *****************
 * User: Dhooper      Date: 5/10/99    Time: 12:35p
 * Updated in $/dev_1200/Include
 * init function call
 * 
 * *****************  Version 9  *****************
 * User: Dhooper      Date: 5/07/99    Time: 1:21p
 * Updated in $/dev_1200/Include
 * IOSTYLE implemented
 * 
 * *****************  Version 7  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 3:41p
 * Updated in $/development/hal_1200
 * update COPYRIGHT
 * 
 * *****************  Version 6  *****************
 * User: Dhooper      Date: 3/08/99    Time: 6:40p
 * Updated in $/development/hal_1200
 * add console read write functions
 * 
 * *****************  Version 5  *****************
 * User: Dhooper      Date: 3/05/99    Time: 3:25p
 * Updated in $/development/hal_1200
 * use xactio if NO_AMBA
 * 
 * *****************  Version 4  *****************
 * User: Dhooper      Date: 3/05/99    Time: 12:46p
 * Updated in $/development/hal_1200
 * swap arguments of sram read and write
 * 
 * *****************  Version 3  *****************
 * User: Dhooper      Date: 3/02/99    Time: 4:20p
 * Updated in $/development/hal_1200
 * cast address to unsigned int before calling ambaio
 * 
 * *****************  Version 2  *****************
 * User: Dhooper      Date: 3/01/99    Time: 12:39p
 * Updated in $/development/hal_1200
 * fix test_and_set_bits, test_and_clear_bits to read from separate reg,
 * add sram read and write
 * 
 * *****************  Version 1  *****************
 * User: Dhooper      Date: 2/26/99    Time: 5:46p
 * Created in $/development/hal_1200
 * sdram and sram HAL
 * 
 * 
 * ---------------------------------------------------------------------
 */
#ifndef __HAL_SRAM_H
#define __HAL_SRAM_H

#include "iostyle.h"
#include "core_io.h"
#include "xact_api.h"

#if (IOSTYLE==XACTIO)

#define SRAM_WRITE(addr, val) XactFastWrite(SRAM, (unsigned int)val, (int) addr);
#define SRAM_READ(addr, val) XactFastRead(SRAM, (int)addr, (unsigned int *)val);

#else
#define SRAM_WRITE(addr, val) WRITE_LWORD(((addr) << 2) + SRAM_READ_WRITE_BEGIN, (val))
#define SRAM_READ(addr, val) READ_LWORD(((addr) << 2) + SRAM_READ_WRITE_BEGIN, (val))

#endif

#define HAL_SRAM_SUCCESS 1


enum SramAddresses{
	SRAM_SLOWPORT_BEGIN =		0x38400000,
	SRAM_SLOWPORT_END =			0x387FFFFF,
	SRAM_CMD_FIFO_TEST_BEGIN =	0x38000080,
	SRAM_CMD_FIFO_TEST_END =	0x380000FF,
#ifndef SRAM_CSR_BASE
	SRAM_CSR_BASE =				0x38000000,
#endif
	SRAM_POPQ =					0x24000000,
	SRAM_PUSHQ =				0x20000000,
	SRAM_TEST_AND_SET_BITS =	0x19800000,
	SRAM_TEST_AND_CLEAR_BITS =	0x19000000,
	SRAM_SET_BITS =				0x18800000,
	SRAM_CLEAR_BITS =			0x18000000,
	SRAM_CAM_UNLOCK =			0x16000000,
	SRAM_WRITE_UNLOCK =			0x14000000,
	SRAM_READ_LOCK =			0x12000000,
	SRAM_READ_WRITE_BEGIN =		0x10000000,
	SRAM_READ_WRITE_END =		0x107FFFFF,
	SRAM_BOOTROM_BEGIN =		0x00000000,
	SRAM_BOOTROM_END =			0x007FFFFF
};

enum SramCsrByteOffsets{
	SRAM_CSR =				0x0,
	SRAM_AUTO_BASE =		0x4,
	SRAM_AUTO_PTR =			0x8,
	SRAM_AUTO_END =			0xC,
	SRAM_TEST_MOD =			0x10,
	SRAM_SLOW_CONFIG =		0x20,
	SRAM_BOOT_CONFIG =		0x24,
	SRAM_SLOWPORT_CONFIG =	0x28,
	SRAM_CMD_FIFO_ADDR =	0x200
};


#ifdef __cplusplus

class SramUnit{
public:
	SramUnit(){}
	~SramUnit(){}

#if ((IOSTYLE==HARDWARE)||(IOSTYLE==AMBAIO))

	inline void setSRAM_CSR(unsigned int val){WRITE_LWORD(&sram_csr, val);}
	inline void getSRAM_CSR(unsigned int *val){READ_LWORD(&sram_csr, val);}

	inline void setSRAM_AUTO_BASE(unsigned int val){WRITE_LWORD(&sram_auto_base, val);}
	inline void getSRAM_AUTO_BASE(unsigned int *val){READ_LWORD(&sram_auto_base, val);}

	inline void setSRAM_AUTO_PTR(unsigned int val){WRITE_LWORD(&sram_auto_ptr, val);}
	inline void getSRAM_AUTO_PTR(unsigned int *val){READ_LWORD(&sram_auto_ptr, val);}

	inline void setSRAM_AUTO_END(unsigned int val){WRITE_LWORD(&sram_auto_end, val);}
	inline void getSRAM_AUTO_END(unsigned int *val){READ_LWORD(&sram_auto_end, val);}

	inline void setSRAM_TEST_MOD(unsigned int val){WRITE_LWORD(&sram_test_mod, val);}
	inline void getSRAM_TEST_MOD(unsigned int *val){READ_LWORD(&sram_test_mod, val);}

	inline void setSRAM_SLOW_CONFIG(unsigned int val){WRITE_LWORD(&sram_slow_config, val);}
	inline void getSRAM_SLOW_CONFIG(unsigned int *val){READ_LWORD(&sram_slow_config, val);}

	inline void setSRAM_BOOT_CONFIG(unsigned int val){WRITE_LWORD(&sram_boot_config, val);}
	inline void getSRAM_BOOT_CONFIG(unsigned int *val){READ_LWORD(&sram_boot_config, val);}

	inline void setSRAM_SLOWPORT_CONFIG(unsigned int val){WRITE_LWORD(&sram_slowport_config, val);}
	inline void getSRAM_SLOWPORT_CONFIG(unsigned int *val){READ_LWORD(&sram_slowport_config, val);}

	inline void setSRAM_CMD_FIFO_ADDR(unsigned short regNum, unsigned int val){WRITE_LWORD(regNum+(unsigned int)(&sram_cmd_fifo_addr), val);}
	inline void getSRAM_CMD_FIFO_ADDR(unsigned short regNum, unsigned int *val){READ_LWORD(regNum+(unsigned int)(&sram_cmd_fifo_addr), val);}

	inline void push(unsigned short queue, unsigned int addr){WRITE_LWORD(addr+SRAM_PUSHQ+(queue<<23), 0);}
	inline void pop(unsigned short queue, unsigned int *addr){READ_LWORD(SRAM_POPQ+(queue<<23), addr);}
	inline void set_bits(unsigned int lwaddr, unsigned int val){WRITE_LWORD(SRAM_SET_BITS+lwaddr, val);}
	inline void clear_bits(unsigned int lwaddr, unsigned int val){WRITE_LWORD(SRAM_CLEAR_BITS+lwaddr, val);}
	void test_and_set_bits(unsigned int lwaddr, unsigned int setval, unsigned int *getval);
	void test_and_clear_bits(unsigned int lwaddr, unsigned int setval, unsigned int *getval);
	inline void write_unlock(unsigned int lwaddr, unsigned int val){WRITE_LWORD((lwaddr << 2) + SRAM_WRITE_UNLOCK, val);}
	inline void read_lock(unsigned int lwaddr, unsigned int *val){READ_LWORD((lwaddr << 2) + SRAM_READ_LOCK, val);}
        int read_lock_spin(unsigned int lwaddr, unsigned int *val);

#endif		//((IOSTYLE==HARDWARE)||(IOSTYLE==AMBAIO))

	inline void write(unsigned int lwaddr, unsigned int val){SRAM_WRITE(lwaddr, val);}
	inline void read(unsigned int lwaddr, unsigned int *val){SRAM_READ(lwaddr, val);}

private:											// word offset: hex byte offset:
	unsigned int sram_csr;							//		0			0x0
	unsigned int sram_auto_base;					//		1			0x4
	unsigned int sram_auto_ptr;						//		2			0x8
	unsigned int sram_auto_end;						//		3			0xC
	unsigned int sram_test_mod;						//		4			0x10
	unsigned int reserve_5_7[3];					//		5-7			0x14-1C
	unsigned int sram_slow_config;					//		8			0x20
	unsigned int sram_boot_config;					//		9			0x24
	unsigned int sram_slowport_config;				//		10			0x28
	unsigned int reserve_11_31[21];					//		11-31		0x29-0x7C
	unsigned int sram_cmd_fifo_addr[32];			//		32-63		0x80-0xFC

};


extern SramUnit	*SRAM_Attach();


extern "C"
{
#endif		// __cplusplus


extern void SRAM_Write(unsigned int addr, unsigned int val);
extern unsigned int SRAM_Read(unsigned int addr);


#if defined(__cplusplus)
}
#endif		// __cplusplus

#endif		// __HAL_SRAM_H (leave next blank line)
