/* GigMacAPI.h
 * GigMac API file 
 *
 * ---------------------------------------------------------------------        
 *  Copyright Digital Equipment Corporation 1997-1998. All rights reserved.
 *
 *  Restricted  Rights:  Use,  duplication,  or  disclosure by the U.S.
 *  Government is subject to restrictions  as set forth in subparagraph
 *  (c)(1)(ii) of DFARS 252.227-7013,  or  in FAR 52.227-19,  or in FAR
 *  52.227-14 Alt. III, as applicable.
 *
 *  This software  is  proprietary  to  and  embodies  the confidential
 *  technology  of  Digital  Equipment  Corporation.  Possession,  use,
 *  or copying of this software and  media  is authorized only pursuant
 *  to  a  valid  written   license   from  Digital  or  an  authorized
 *  sublicensor.
 * ---------------------------------------------------------------------
 *
 * system: SA1200
 * subsystem: GigMacDriver
 * author: sk, Apr 99 Initial version
 * $History: GigMacAPI.h $
 * 
 * *****************  Version 4  *****************
 * User: Skornfel     Date: 9/07/99    Time: 2:13p
 * Updated in $/dev_1200/SA1_CoreLibs/GigaMAC_GC82547EB
 * Changed the default to LITTLE ending
 * 
 * *****************  Version 2  *****************
 * User: Skornfel     Date: 7/30/99    Time: 3:10p
 * Updated in $/dev_1200/SA1_CoreLibs/GigaMAC_GC82547EB
 * controls 21640 on SA1200 eval board
 * 
 * *****************  Version 1  *****************
 * User: Skornfel     Date: 7/16/99    Time: 2:32p
 * Created in $/dev_1200/Include
 * 
*/
 
#ifndef GIG_MAC_DRIVER_API_H
#define GIG_MAC_DRIVER_API_H


enum PotrtRunDirection{
	RX_AND_TX = 0,
	RX = 1,
	TX = 2
};
enum BusWidth{
	BUS_WIDTH_32 = 0,
	BUS_WIDTH_64 = 1,
	BUS_SPLIT    = 2,
	BUS_RESERVED = 3
};

  enum Endian{
		LITTLE = 0,
		BIG = 1
  };

#ifdef __cplusplus
extern "C" {
#endif

//externs

void GigMACCreateDriver ();

int GigMACStartPort (int port, int port_run_direction/* = RX_AND_TX*/);

int GigMACStopPort (int port, int port_stop_direction/* = RX_AND_TX*/ );

int GigMACResetPort  (int port );

int GigMACCofigureFifoAndBusWidthOnPort(int port, 
												 BusWidth bus_width/*=BUS_WIDTH_64*/,
												 int rx_threshold /* max 0x7f(6f) */, 
												 int tx_threshold /* max 0x3f */
												 ); 

int GigMACResetAll();
int GigMACCofigureEndian(Endian order/*LITTLE*/); 

#ifdef __cplusplus
}
#endif
#endif  /* GIG_MAC_DRIVER_API_H */
















