//------------------------------------------------------------------------------------
//                                                                      
//                   I N T E L   P R O P R I E T A R Y                   
//                                                                       
//      COPYRIGHT (c)  1998-99 BY  INTEL  CORPORATION.  ALL RIGHTS          
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//      THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                       
//                         INTEL  CORPORATION                            
//                                                                      
//                      2200 MISSION COLLEGE BLVD                        
//                                                                       
//                SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                       
//------------------------------------------------------------------------------------
// rec_bridge.uc
// bridge lookup
//
// Version = 1.0.NoBldNum
//
// system: SA1200
// subsystem: receive microcode
// usage: bridge forwarding decision
// author: dfh  3/26/99 complete rewrite
//


// ---------------------------SA1200 microcode--------------------------

// Prerequisite: 
//	rec_nextpac.uc   has executed
//	first 4 longwords of the packet has been read in from reveive FIFO
//
//	register usage at this point
//
//	$xfer0 					MAC DA<31:0>
//	$xfer1					MAC  DA<48:32> and SA<15:0> 
//	$xfer2					MAC  SA<31:0>  
//	$xfer3					MAC length and bridge protocol
//	protocol_len			datalink payload length
//	packet_buf_addr			address of buffer in sdram where packet will be stored
//	buf_handle				address offset of the current descriptor
//	rec_state				fastport flag, packet sequence number, byte enables, eop, sop


.local sram_port_state_base_const da_port_state sa_port_state da_port_num br_protocol da_lookup_result sa_lookup_result recv_port_num


.xfer_order $xfer0 $xfer1 $xfer2 $xfer3 $xfer4 $xfer5 $xfer6 $xfer7
.xfer_order $$xfer0 $$xfer1 $$xfer2 $$xfer3 $$xfer4 $$xfer5 $$xfer6 $$xfer7



//   ***************   IDEAL ETHERNET/802.3 FUNCTION   ********************
//
//
//  Important Data Structures:
//
//
//  ******** The SRAM Data Structures:
//   
//       The level 1 hash table.  Indexed by hash result<15:0>.         
//       base address SRAM_L1_ADDR_HASH_BASE(see mem_map.h):	2**16 (10000 hex) longword entries  256KB
//
//       The level 2 hash table. Indexed by (l2_index<<L2_shift) OR (hash result<48:16> and L2_mask).     
//       base address SRAM_L2_ADDR_HASH_BASE(see mem_map.h):			size is determined by software. >=64KB  
//
//       lookup_result - value from the L1 hash table
//			if (lookup_result<30> = 1), entry is locked, wait for it to be unlocked
//
//			else if (lookup_result == 0), entry not in table
//
//			else if (lookup_result<31> == 0), no collision, lookup_result is index to database
//
//			else if (lookup_result<31> == 1), collision:
//				<29>    MBZ
//				<28:5>  L2_table select - 16 bits
//				<4:0>   L2_shift - hash table index shift left amount - 5 bits.  Format is 32-shift left amount
//
//
//       br_protocol lookup:		sram[br_protocol_base + br_protocol]		 256 entries
//			result:
//
//			 	1 = Q to core (BPDU)
//				0 = handle by microcode. forward/filter decision   
//
//
// SDRAM forwarding entry per MAC address(shared DA and SA):
//		at sdram[SDRAM_BRIDGE_FWD_BASE+forwarding_table_index]
//
//      longword0:	       
//               <31:5>		- possible channel information
//               <4:0>		- destination port Number
//
//      longword1:			- possible filter information
//      longword2:			- hash remainder - 32 bits
//      longword3:			- not used
//
//
// SRAM port state
//       at sram[SRAM_PORT_STATE_BASE + (port_num<<2)]
//
//		longword0: used by  forwarding routine
//  
//	            <31:4>	- possible trap info
//				<2:0>	- port state
//					0 = forwarding
//					1 = listening
//					2 = learning
//					3 = blocking
//					4 = disabled
//
//		longwords1-3:	used by spanning tree routines
//
//

// note: this version supports up to 32 ports (thus we take only 5 bits of the port num)

rec_bridge#:
	extract_field[br_protocol, $xfer3, 2, 2]			; bridge protocol field = byte 2


// move 64 bytes of packet data from receive fifo element to sdram (macro defined in stdmac.uc)
//
	sdram_r_fifo_rd[packet_buf_addr, rfifo_entry, 0, 8, ASYNC]




// ----------------------- hardware hash lookup  -------------------------------
//
	alu_shf[recv_port_num, 0x1f, AND, $xfer7, >>24]	; get receive port number from rcv cntl


// setup for da hash
    dbl_extract_field[tempa, $xfer0, 2, $xfer1, 1]	; load DA bytes 2-5 to write xfer reg for hash
	move[$xfer2, tempa]

// setup for sa hash
// note: sa hash lookup is performed but results are unused in this version
#ifdef LITTLE_ENDIAN
    extract_field[tempa, $xfer0, 0, 1]				; load DA bytes 0-1 to write xfer reg for hash
	move[$xfer1, tempa]
    extract_field[tempa, $xfer1, 2, 3]				; load SA bytes 0-1 to write xfer reg for hash								
	move[$xfer3, tempa]
	swap[tempa, $xfer2]
	move[$xfer4, tempa]								; load SA bytes 2-5 to write xfer reg for hash
#else
	alu[$xfer1, 0, +16, $xfer0, >>16]				; load DA bytes 0-1 to write xfer reg for hash
	alu[$xfer3, 0, +16, $xfer1]						; load SA bytes 0-1 to write xfer reg for hash	
    move[$xfer4, $xfer2]							; load SA bytes 2-5 to write xfer reg for hash
#endif

start_protocol_lookup#:
	
	immed32[tempa, SRAM_PROTOCOL_BASE]
	sram[read, $xfer5, tempa, br_protocol, 1], sig_done		; protocol lookup

start_hash#:

	hash2_48[$xfer1], ctx_swap						; Hash the DA and SA

	ctx_arb[sram]									; protocol lookup complete


// Wake up here - the 2 hash ops are complete.   Register usage:
//
// $rxfer 1,2 - hash result DA
// $rxfer 3,4 - hash result SA
// $rxfer 5		protocol lookup
//

// hash lookup DA and SA
//
	immed32[tempb, SRAM_L1_ADDR_HASH_BASE]
	ld_field_w_clr[tempa, 0011, $xfer2]					; table index = low 16 bits of hash result
    sram[read, $xfer7, tempa, tempb, 1]					; lookup DA, SRAM_L1 hash

	ld_field_w_clr[tempa, 0011, $xfer4]					; table index = low 16 bits of hash result
    sram[read, $xfer6, tempa, tempb, 1], ctx_swap		; lookup SA, SRAM_L1 hash

    move[da_lookup_result, $xfer7]						; check results of DA lookup in hash table 1
	br>0[sa_resolve#]
da_resolve#:
	hashdb_resolve[$xfer1, $xfer2, da_lookup_result, SRAM_L2_ADDR_HASH_BASE]

sa_resolve#:
    move[sa_lookup_result, $xfer6]						; check results of SA lookup in hash table 1
	br>0[hash_lookup_success#]
	hashdb_resolve[$xfer3, $xfer4, sa_lookup_result, SRAM_L2_ADDR_HASH_BASE]

hash_lookup_success#:


// we should have the signal back by now for completion of the transfer from rfifo to sdram
//
	ctx_arb[sdram]						; wait for transfer from rfifo to be done


//	Write thread done as soon as the rfifo element is transferred to sdram
//  By the time it turns around and get sot the Receive Scheduler, this thread will be done
//
#ifdef FAST_PORT_ENABLED
	.if (bit(rec_state, 31) == 1)		; if fastport
		fast_wr[2, THREAD_DONE]			; notify receive scheduler with EOP encode
	.else
#endif
		.if (bit(rec_state, 9) == 1)	; if EOP
			fast_wr[3, THREAD_DONE]		; notify receive scheduler with EOP encode
		.else
			fast_wr[1, THREAD_DONE]		; notify receive scheduler witn non-EOP encode
		.endif

#ifdef FAST_PORT_ENABLED
	.endif
#endif

	.if (da_lookup_result == 0)
		br[no_hash_entry#]
	.endif
	.if (sa_lookup_result > 0)
    sdram[read, $$xfer4, 0, sa_lookup_result, 1]			; read the database entry for SA (2 longwords)
	.endif
    sdram[read, $$xfer0, 0, da_lookup_result, 2], ctx_swap	; read the forwarding table for DA (4 longwords)

// Wakeup here - have forwarding table entry
// Register usage:
// $$rxfer0, $$rxfer1, $$rxfer2, $$rxfer3  - DA forwarding table entry
//
    alu[da_port_num, $$xfer0, AND, 0x1f]					; isolate DA port number from forwarding table
 



//
// SRAM port state
//       at sram[SRAM_PORT_STATE_BASE + (port_num<<2)]
//
//		longword0: used by  forwarding routine
//  
//	            <31:4>	- possible trap info
//				<3:0>	- port state
//					0 = forwarding
//					1 = listening
//					2 = learning
//					3 = blocking
//					4 = disabled

	immed32[sram_port_state_base_const, SRAM_PORT_STATE_BASE]

    alu_shf[tempa, --, B, da_port_num, <<2]
    sram[read, $xfer4, sram_port_state_base_const, tempa, 1]

    alu_shf[tempa, --, B, recv_port_num, <<2]
    sram[read, $xfer5, sram_port_state_base_const, tempa, 1], ctx_swap



// Wake up here - have da port state
// Register usage:
// $write xfer - all available
// $rxfer 4 - source port state
// $rxfer 5 - dest port state
// $$write xfer - all available
// $$rxfer0, $$rxfer1, $$rxfer2, $$rxfer3  - DA forwarding table entry  $$rxfer1 synonym to $$da_fwd1
// $$rxfer4, $$rxfer5, $$rxfer6, $$rxfer7  - SA forwarding table entry  $$rxfer5 synonym to $$sa_fwd1


//  Main Bridge forwarding decision section
//
//
//
//
// The job of the forwarding decision section is to choose a queue (qselect+da_port_num) for this packet,
// and to increment a counter upon processing this packet(counterid).  
//

// Here we have simplified it to make one of several choices:
//
//		1. Queue to destination port. Normal forwarding.
//		2. Queue to spanning tree algorithm (trap). Let Bridge Manager in core handle the packet.
//			If spanning tree is done by Bridge Manager, BPDUs go there.
//		3. Discard the packet
//			If da_port_num == recv portnum, discard
// 

main_fwd_decision#:
    alu[--, da_port_num, -, recv_port_num]     ; check if the dest port = recv port
    br=0[packet_late_discard#]
    immed[exception, BR_SOURCE_EQ_DEST_PORT]									; 

	alu[--, $xfer4, AND, 0xf]					; da_port_state
	br>0[trap_packet#]							; queue to spanning tree

	alu[--, $xfer5, AND, 0xf]					; sa_port_state
	br>0[trap_packet#]							; queue to spanning tree

    br[header_stored#], defer[1]				; goto rec_enqueue
	alu[rec_state, rec_state, OR, da_port_num]	; capture the output port


trap_packet#:
//	tbd: send BPDUs to spanning tree
//	if spanning tree is done in core, queue the packet to core
//  if done in microcode, branch there



no_hash_entry#:					; hash table entry = 0, not in table - forward to default port

// read default port
	immed32[tempa, SDRAM_BRIDGE_FWD_BASE]

	sdram[read, $$xfer0, 0, tempa, 2], ctx_swap		; read 1st default forwarding entry for DA (8 longwords)
	alu[da_port_num, $$xfer0, AND, 0x1f]			; isolate DA port number from forwarding table

	.if(recv_port_num == da_port_num)
		sdram[read, $$xfer0, 4, tempa, 2], ctx_swap ; read 2nd forwarding entry for DA (4 longwords)
		alu[da_port_num, $$xfer0, AND, 0x1f]		; isolate DA port number from forwarding table
	.endif
	
    br[header_stored#], defer[1]					; goto rec_enqueue
	alu[rec_state, rec_state, OR, da_port_num]		; capture the output port

.endlocal											; free the local registers

