; memsv.uc
; microcode memory service routines
;;
; ------------------------------------------------------------------------------------------------------------
;                                                                      
;                  I N T E L   P R O P R I E T A R Y                   
;                                                                      
;     COPYRIGHT (c)  1998 BY  INTEL  CORPORATION.  ALL RIGHTS          
;     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
;     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
;     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
;     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
;     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
;     THE PRIOR WRITTEN PERMISSION OF :                                
;                                                                      
;                        INTEL  CORPORATION                            
;                                                                     
;                     2200 MISSION COLLEGE BLVD                        
;                                                                      
;               SANTA  CLARA,  CALIFORNIA  95052-8119                  
;                                                                      
;------------------------------------------------------------

; system: SA1200
; subsystem: Service
; usage: memory services subroutines performed on behalf of the core or host
; author: dfh 2/9/98
; Version = 1.0.NoBldNum
; revisions:
;
; ---------------------------SA1200 microcode--------------------------	
;
; subroutines:
;
;		MemSv_TestAndSetSubr#
;		MemSv_BZeroSubr#
;		MemSv_BCopySubr#
;		MemSv_GatherSubr#
;		MemSv_ScatterSubr#
;
;----------------------------------------------------------------------
; MemSv_TestAndSet
;	bitwise for data at addr, set the bit if it is 0.
;	return the value of data before the bits were set
;
;	input argument registers:
;		data = $xfer1	// bits to set
;		addr = $xfer2	// address of bit vector
;	output argument registers:
;		data = $xfer1	// bits before set
;
;	note: for now this is sram only
;----------------------------------------------------------------------
MemSv_TestAndSetSubr#:
	alu[$xfer1, --, B, $xfer1]
	alu[$xfer2, --, B, $xfer2]
	sram[bit_wr, $xfer1, $xfer2, 0, test_and_set_bits], ctx_swap
	alu[$xfer1, --, B, $xfer1]
	immed[format, 1]				; 1 argument reply
	; return
	alu_shf[--, 0, B, reply, >>31]	; bit 31 on means synchronous
	; if synchronous, go ack
	br>0[Sv_Ack#]					; go call the function
	; asynchronous, function done
	br[Sv_WaitForCall#]



;----------------------------------------------------------------------
; MemSv_BZero
;	zero a memory buffer
;		input argument registers:
;		len = $xfer1	// byte count
;		addr = $xfer2	// buffer starting address
;
;	note: for now this is sram only. 2 lsbs of address and length are ignored
;----------------------------------------------------------------------
;TBD also test whether sram or sdram
; assume for now len is multiples of 4 bytes
; and from and to addresses are longword aligned
;
; $xfer0-7 = 0							
; for(i=0; (i+32)<len; i +=32){
;		sram[write, $xfer0, addr, i, 8]		// no context_swap, let it rip
;
MemSv_BZeroSubr#:
	alu[len, --, B, $xfer1, >>2]
	alu[addr, --, B, $xfer2, >>2]			; convert byte address to word address
	immed[i,0]
	alu[$xfer0,--,B, 0]
	alu[$xfer1,--,B, 0]
	alu[$xfer2,--,B, 0]
	alu[$xfer3,--,B, 0]
	alu[$xfer4,--,B, 0]
	alu[$xfer5,--,B, 0]
	alu[$xfer6,--,B, 0]
	alu[$xfer7,--,B, 0]
_MemSv_BZero_loop#:
	alu[--, len, -, 8]			; test for less than 8 words remaining
	br<0[_msv_bzero_write_n#]
	sram[write, $xfer0, addr, i, 8], ctx_swap
	alu[i, i, +, 8]
	alu[len, len,-,8]
	br=0[_msv_bzero_return#]	; test for no words remaining
	br[_MemSv_BZero_loop#]
_msv_bzero_write_n#:			; write last less then 8 words
	alu[--, len, -, 0]			; test for 0
	br=0[_msv_bzero_return#]
	alu[len, len, -, 1]			; indirect sram write uses len-1 for len
	alu_shf[indirect_wr_len, len, OR, 0x10]		; setup word count
	alu_shf[indirect_wr_len, --, B, indirect_wr_len, <<16]
	sram[write, $xfer0, addr, 0, 1], indirect_ref, ctx_swap
_msv_bzero_return#:
	alu_shf[--, 0, B, reply, >>31]	; bit 31 on means synchronous
	; if synchronous, go ack
	br>0[Sv_Ack#]					; go call the function
	; asynchronous, function done
	br[Sv_WaitForCall#]




;----------------------------------------------------------------------
; MemSv_BCopy
;	copy a buffer from one memory address to another
;	input argument registers:
;		len = $xfer1	//	byte count
;		from = $xfer2	//  from buffer location
;		to = $xfer3		//	to buffer location
;
;	note: for now this is sram only. 2 lsbs of address and length are ignored
;----------------------------------------------------------------------
;
; assume for now len is multiples of 4 bytes
; and from and to addresses are longword aligned
;
; for(i=0; i<len; i +=32){
;		sram[read, $xfer0, from, i, 8], ctx_swap
;		$xfer0-7 = $xfer0-7			;copy read xfer to write xfer
;		sram[write, $xfer0, from, i, 8], ctx_swap
;
MemSv_BCopySubr#:
	alu[len, --, B, $xfer1, >>2]
	alu[from, --, B, $xfer2, >>2]	; convert byte address to word address
	alu[to, --, B, $xfer3, >>2]
	immed[link_pc,0]				; call from core apps
_msv_bcopy_subr#:
	immed[i,0]
	alu[bcopy_len, --, B, len]
_msv_bcopy_loop#:
	alu[--, bcopy_len, -, 8]				; test for less than 8 words remaining
	br<0[_msv_bcopy_write_n#]
	sram[read, $xfer0, from, i, 8], ctx_swap
	alu[$xfer0,--,B,$xfer0]
	alu[$xfer1,--,B,$xfer1]
	alu[$xfer2,--,B,$xfer2]
	alu[$xfer3,--,B,$xfer3]
	alu[$xfer4,--,B,$xfer4]
	alu[$xfer5,--,B,$xfer5]
	alu[$xfer6,--,B,$xfer6]
	alu[$xfer7,--,B,$xfer7]
	sram[write, $xfer0, to, i, 8], ctx_swap
	alu[i, i, +, 8]
	alu[bcopy_len, bcopy_len,-,8]
	br[_msv_bcopy_loop#]			; test for no words remaining
; otherwise finish, copying 1-7 words
; setup indirect for sram command later
_msv_bcopy_write_n#:				; write last less then 8 words
	alu[--, bcopy_len, -, 0]		; test for 0
	br=0[_msv_bcopy_return#]
	alu[bcopy_len, bcopy_len, -, 1] ; indirect sram write uses len-1 for len
	alu_shf[indirect_wr_len, bcopy_len, OR, 0x10]		; setup word count
	alu_shf[indirect_wr_len, --, B, indirect_wr_len, <<16]
	sram[read, $xfer0, from, i, 1], indirect_ref, ctx_swap
	; move bcopy_len words to write xfer
	alu[$xfer0,--,B,$xfer0]
	alu[$xfer1,--,B,$xfer1]
	alu[$xfer2,--,B,$xfer2]
	alu[$xfer3,--,B,$xfer3]
	alu[$xfer4,--,B,$xfer4]
	alu[$xfer5,--,B,$xfer5]
	alu[$xfer6,--,B,$xfer6]
	alu[$xfer7,--,B,$xfer7]
test#:
	alu[--, 0, B, indirect_wr_len]
	sram[write, $xfer0, to, i, 1], indirect_ref, ctx_swap
_msv_bcopy_return#:
	alu[--, link_pc, -, 0]			; test if a subroutine call
	br>0[_msv_bcopy_rtntosubr#]
	alu_shf[--, 0, B, reply, >>31]	; bit 31 on means synchronous
	; if synchronous, go ack
	br>0[Sv_Ack#]					; go call the function
	; asynchronous, function done
	br[Sv_WaitForCall#]
_msv_bcopy_rtntosubr#:
	rtn[link_pc]



;----------------------------------------------------------------------
; MemSv_Gather
;	concatenate multiple buffers by copying to one contiguous buffer
;	input arguments
;		count = $xfer1:	int	mailbox word 3	number of buffers
;		from = $xfer2:	int	mailbox word 1	from msvbufs location
;						each msvbuf consists of length and address 
;		to = $xfer3:	int	mailbox word 2	to buffer location
;
;	note: for now this is sram only. 2 lsbs of address and length are ignored
;----------------------------------------------------------------------
MemSv_GatherSubr#:
;
; for each msvbuf, copy the small buffer to the "to" big buffer

	alu[count, --, B, $xfer1]
	alu[msvbufs, --, B, $xfer2]
	alu[to, --, B, $xfer3]
_msv_gather_get_msvbuf#:
	sram[read, $xfer0, msvbufs, 0, 2], ctx_swap
	alu_shf[len, --, B, $xfer0, >>2]			; NOTE for now this is lwords only
	alu_shf[from, --, B, $xfer1, >>2]			; NOTE for now this is lwords only
	load_addr[link_pc, _msv_gather_copied#]
	br[_msv_bcopy_subr#]
_msv_gather_copied#:
	alu[count, count, -, 1]
	br<=0[_msv_gather_return#]		; if more, get next msvbuf
	alu[msvbufs, msvbufs, +, 2]
	alu_shf[to, to, +, len]
	br[_msv_gather_get_msvbuf#]
_msv_gather_return#:
	alu_shf[--, 0, B, reply, >>31]	; bit 31 on means synchronous
	; if synchronous, go ack
	br>0[Sv_Ack#]					; go call the function
	; asynchronous, function done
	br[Sv_WaitForCall#]

;----------------------------------------------------------------------
; MemSv_Scatter
;	copy to one contiguous buffer to multiple buffers
;	input arguments
;		count = $xfer1:		int	mailbox word 3	number of buffers
;		from = $xfer2:		int	mailbox word 1	from buffer location
;		to = $xfer3:		int	mailbox word 2	to buffers location
;
;	note: for now this is sram only. 2 lsbs of address and length are ignored
;----------------------------------------------------------------------
MemSv_ScatterSubr#:
;
; for each msvbuf, copy the small buffer to the "to" big buffer

	alu[count, --, B, $xfer1]
	alu[from, --, B, $xfer2]
	alu[msvbufs, --, B, $xfer3]
_msv_scatter_get_msvbuf#:
	sram[read, $xfer0, msvbufs, 0, 2], ctx_swap
	alu_shf[len, --, B, $xfer0, >>2]	; NOTE for now this is lwords only
	alu_shf[to, --, B, $xfer1, >>2]		; NOTE for now this is lwords only
	load_addr[link_pc, _msv_scatter_copied#]
	br[_msv_bcopy_subr#]
_msv_scatter_copied#:
	alu[count, count, -, 1]
	br<=0[_msv_scatter_return#]
	alu[msvbufs, msvbufs, +, 2]		; if more, get next msvbuf
	alu_shf[from, from, +, len]
	br[_msv_scatter_get_msvbuf#]
_msv_scatter_return#:
	alu_shf[--, 0, B, reply, >>31]	; bit 31 on means synchronous
	; if synchronous, go ack
	br>0[Sv_Ack#]					; go call the function
	; asynchronous, function done
	br[Sv_WaitForCall#]

; end of file