//------------------------------------------------------------------------------------
//                                                                     
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                      
//-----------------------------------------------------------------------------------
// mem_map.h
//		shared memory between core and microcode
//
//
// system: SA1200
// subsystem: core and microcode
// usage: address ranges, shared addresses
// author: dfh 2/18/98
// revisions:
//		7/4/98	dfh		support FAST PORT
//		5/21/99 dfh		sdram non_cache area, with sdram addresses using this as offset
//
// ---------------------------------------------------------------------

// note: microcode assembler reads this file, so full C directive syntax is not available



// --------------------------SDRAM-------------------------------------------
// define non cache sdram region that microcode will use
//
// if ucode using high memory
// note: this will result in additional immed instructions needed to load the addresses in microcode 
//
// assumes 1MB sections, OS runs in low 1MB      
//#define SDRAM_NONCACHE_QWD_START	0x20000		// 128KQW, 1MB
//#define SDRAM_NONCACHE_QWD_END   0x100000		// 1MQW,   8MB

// if ucode using low memory, get best microcode performance
//
#define SDRAM_NONCACHE_QWD_START	  0x100		// 256QW,  2KB
#define SDRAM_NONCACHE_QWD_END		0x300000		// 3MQW, 24MB
// assumes 1MB sections, OS runs in 4MB-5MB



// define base quadword addresses for forwarding entries and packet data 
//
#define SDRAM_BRIDGE_FWD_BASE	(  0x100 + SDRAM_NONCACHE_QWD_START)	// bridge forward entry space 32KQW 256KB
#define SDRAM_ROUTE_FWD_BASE	( 0x8000 + SDRAM_NONCACHE_QWD_START)	// route forward entry space 96KQW 768KB 
#define SDRAM_PKT_BUFFER_BASE   (0x20000 + SDRAM_NONCACHE_QWD_START)	// packet memory buffer space
#ifdef BANK_SIZE_16MB
#define SDRAM_PKT_BUFFER_HIGH_BASE   (0x200000 + SDRAM_PKT_BUFFER_BASE)	// packet memory B bank buffer space
#else
#define SDRAM_PKT_BUFFER_HIGH_BASE   (0x100000 + SDRAM_PKT_BUFFER_BASE)	// packet memory B bank buffer space
#endif

// define temporary sdram location for debug library
//
#define SDRAM_UDEBUG_TMPADR		(SDRAM_NONCACHE_QWD_START)	// 2 quad words (16 bytes)

// -------------------------SCRATCH--------------------------------------------
// scratch static allocations

// tx messages and signals
// longword offset from SCRATCH_START
//
#define EXCEPTION_COUNTERS			    0		// each receive thread has 16 exception counters
												// 0 - 0xbf
#define TOTAL_DISCARDS				 0xc0		// total of all exception counters
#define TOTAL_RECEIVES				 0xc1		// total packets enqueued
#define TOTAL_TRANSMITS				 0xc2		// total packets transmitted


#define SCRATCH_BRIDGE_COUNTER_BASE 0x100		// 16 longwords for statistics up to 0x22f
#define XMIT_PWP_VECTOR				0x200		// bit vector ports with packet


// this could be either in scratch or sram, dedending on the code
#define XMIT_TASK_MSG_BASE 			0x204		// TFill task assignments 4 threads

#define REC_SLOW_PORT_STATE			0x240		// slow port save state locations to 0x25F


// packet forwarding reference design locations
#define RX_FPORT1_OUTPORT			0x280		// fast output port from thread that did the lookup
#define RX_FPORT2_OUTPORT			0x290		// fast output port from thread that did the lookup

#define ODD_SEQ_CNT_FLAG_ADDR_1		0x300
#define ODD_SEQ_CNT_FLAG_ADDR_2		0x301


// -----------------------------SRAM----------------------------------------
//************************************************************************
// SRAM usage in words (hex): 
// Start  End+1   Reason
//  0001   0061   UThread to Core mailboxes
//  0064   00C4   Core to UThread mailboxes
//  00C8   00CB   VxWorks Scratch Area
//  0300   0400   SRAM queue descriptors
//  04A0   04A2   gig port counts
//  04C0   04E0   fast port save & restore
//  0500   0CD0   SRAM buff descriptors
//  1000   2000   Fast port descriptors
//
//  4400   4500   SRAM protocol base L1 table     ONLY FOR BRIDGE
//  4500  14500   L1 addr hashes                  ONLY FOR BRIDGE
// 14500  14D00   sram port state base            ONLY FOR BRIDGE
// 14D00  15D00   sram hashdb prt base            ONLY FOR BRIDGE
// 15D00  16D00   sram vlan base                  ONLY FOR BRIDGE
// 16D00  20000   sram l2 addr hash base          ONLY FOR BRIDGE
//
// 20000  80000   route tables
// ************************************************************************/


// sram addresses for core/uc messages

#define UTHREAD_TO_CORE_MAILBOXES		  1		// 24 x 16byte mailboxes
#define CORE_TO_UTHREAD_MAILBOXES		100		// =400(byte addr), 24 x 16byte mailboxes

// Scratch area for VxWorks, 3 words long
#define VXWORKS_SCRATCH_AREA			200		// decimal 200 words, 800 bytes

// sram queue addresses
// longword offset from SRAM_START
//
#define SRAM_QUEUE_DESCRIPTOR_BASE	  0x300		// 16words x 16 ports = 128 0x100


// Added by tungfai
#define RESERVATION_TABLE_BASE				0x8000
#define TABLE_RECORD_LEN					0x7
#define TABLE_COUNT_LOCATION				0x8FFF




#ifdef RTM_MVR
// gigabit port queued element count addresses
#define XMIT_FPORT1_ELE_COUNT		  0x4A0		// gigabit port element count
#define XMIT_FPORT2_ELE_COUNT		  0x4A1		// gigabit port element count
#define SRAM_MPACKET_MAILBOX		  0x4C0		// for fast port receive save and restore
#else
#define XMIT_FPORT1_ELE_COUNT		 0xd0		// gigabit port element count
#define XMIT_FPORT2_ELE_COUNT		 0xd1		// gigabit port element count
#endif


#define SRAM_MPACKET_MAILBOX_1		  0x4C0		// for fast port receive save and restore
												// (32 locations to 0x4DF)
#define SRAM_MPACKET_MAILBOX_2		  0x4E0		// for fast port receive save and restore
												// (32 locations to 0x4FF)

#define SRAM_BUFF_DESCRIPTOR_BASE	  0x500		// 2words x 1000 descriptors
#define XMIT_FPORT_DESCRIPTOR_BASE	 0x1000		// FAST PORT DESCRIPTORS array
												// 2 words * 128 * 8 queue per 1-2 ports
#define XMIT_FPORT_DESCRIPTOR_BASE_2 0x1800		// FAST PORT DESCRIPTORS array
												// 2 words * 128 * 8 queue per 2nd fast port

// bridge addresses
// 64K L1 Table
#define SRAM_PROTOCOL_BASE			 0x4400		// 256 entries
#define SRAM_L1_ADDR_HASH_BASE		 0x4500		// 17664 (size 64k words)
// SIZE of Table is specified in the br_config.h
#define SRAM_PORT_STATE_BASE		0x14500		// 83200 (size 2K)
#define SRAM_HASHDB_PTR_BASE		0x14D00		// 8K	hardware freelist pointers for bridge fwd database
#define SRAM_VLAN_BASE				0x15D00		// 8k entries for filter vlan tags may be used in future
#define SRAM_L2_ADDR_HASH_BASE		0x16D00		// variable size ( allocated in chunk of 8k)


#ifdef RTM_MVR
#define SRAM_FIRST_TRIES            0x20000     // array of trie pointers indicating where start for each port
#define SRAM_ROUTE_LOOKUP_BASE	SRAM_FIRST_TRIES
#define SRAM_DYNAMIC_LWD_START		0x20010		// used for route tables
#else
#define SRAM_DYNAMIC_LWD_START		0x20000		// used for route tables
#define SRAM_ROUTE_LOOKUP_BASE	SRAM_DYNAMIC_LWD_START
#endif



// ----------------------------PUSH/POP----------------------------------------
// freelist base address pointers
//	see stdmac.uc
#define FREELIST_BTYPE_SRAM8_SDRAM2K	  0			// freelist 0 is used for packet data and queue
// freelist buffer initial allocation
// note: this is set low for use in simulation 
#define FREELIST_BTYPE_SRAM8_SDRAM2K_COUNT 100

#define STORAGE_CLASS_SRAM 0
#define STORAGE_CLASS_SDRAM 1
#define STORAGE_CLASS_SRAM_SDRAM 2

#define FREELIST0_BASE SRAM_BUFF_DESCRIPTOR_BASE	// sram packet descriptors
#define FREELIST1_BASE SDRAM_BRIDGE_FWD_BASE		// hashdb
#define FREELIST2_BASE SRAM_L2_ADDR_HASH_BASE		// hashdb L2

// identify the type of storage the freelist references
#define FREELIST0_TYPE STORAGE_CLASS_SRAM_SDRAM
#define FREELIST1_TYPE STORAGE_CLASS_SDRAM
#define FREELIST2_TYPE STORAGE_CLASS_SRAM

// if using malloc on sdram storage class, need sdram sdride
#define FREELIST1_PTR_BASE SRAM_HASHDB_PTR_BASE
#define FREELIST1_PTR_SHIFT	2						// ptr x4 each entry 8 longwords

// define which push pop queue freelists are initialized by microcode
#define UCODE_QUEUES_MASK 0x01
