//------------------------------------------------------------------------------------
//                                                                     
//                  I N T E L   P R O P R I E T A R Y                   
//                                                                      
//     COPYRIGHT (c)  1999-2000 BY  INTEL  CORPORATION.  ALL RIGHTS          
//     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//     THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                      
//                        INTEL  CORPORATION                            
//                                                                     
//                     2200 MISSION COLLEGE BLVD                        
//                                                                      
//               SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                      
//-----------------------------------------------------------------------------------
// sem.uc
// semaphore macros
//
//
// system: IXP1200
// subsystem: OS Emulation microcode
// usage: library macros
//
// revisions:
//		beta3 Dec 10, 1999	dfh			initial version	
//		v1.0, May 1, 2000,  jdg, dfh	separated from stdmac
//										sem_init initializes to 1, add sem_set, sem_clr
										


#ifndef SEM_UC
#define SEM_UC


// API:
//	sem_init[_abs_reg]
//  sem_wait[_abs_reg]
//	sem_set[_abs_reg]
//	sem_clr[_abs_reg]


// A semaphore is a method of inter-thread comunication within a microengine. 
// It uses an absolute reg, where bit 31 is the semaphore.
 


// sem_init
//		description: Initialize semaphore to 1 (bit 31 set). 
//					 Semaphore set allows sem_wait to complete.
//		inputs: 
//			_abs_reg		absolute register containing the semaphore
//
#macro sem_init[_abs_reg]
	immed[_abs_reg, 0xFFFFFFFF]
#endm


// sem_wait 
// 		description: Wait for bit 31 to be set, while allowing other threads to run.
//					 If semaphore is set, exit. Else wait for it to be set.
//		inputs: 
//			_abs_reg		absolute register containing the semaphore
//
#macro sem_wait[_abs_reg]
begin#:
	alu[--, --, B, _abs_reg]
	br<0[end#], guess_branch
	ctx_arb[voluntary]
	br[begin#]
end#:
#endm


// sem_set
//		description: Set semaphore (wait can complete).
//					 Semaphore set allows sem_wait to complete.
//		inputs: 
//			_abs_reg		absolute register containing the semaphore
//
#macro sem_set[_abs_reg]
	immed[_abs_reg, 0xFFFFFFFF]
#endm


// sem_clr
//		description: Clear semaphore (wait will block).
//					 Semaphore cleared causes sem_wait to block.
//		inputs: 
//			_abs_reg		absolute register containing the semaphore
//
#macro sem_clr[_abs_reg]
	immed[_abs_reg, 0]
#endm


// sem_flip
//		description: Invert the semaphore.
//		inputs: 
//			_abs_reg		absolute register containing the semaphore
//
#macro sem_flip[_abs_reg]
	alu[_abs_reg, --, ~B, _abs_reg]
#endm

#endif // SEM_UC
