//------------------------------------------------------------------------------------
//                                                                      
//                   I N T E L   P R O P R I E T A R Y                   
//                                                                       
//      COPYRIGHT (c)  2000 BY  INTEL  CORPORATION.  ALL RIGHTS          
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//      THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                       
//                         INTEL  CORPORATION                            
//                                                                      
//                      2200 MISSION COLLEGE BLVD                        
//                                                                       
//                SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                       
//------------------------------------------------------------------------------------
// scratch.uc
// macros to access scratch pad 
//
//
// system: IXP1200
// subsystem: utility microcode
// usage: library macros
// author: dfh	May 1, 2000
//
// revisions:


#ifndef SCRATCH_UC
#define SCRATCH_UC


// API:
//	scratch_read[_xfer, _base_lw_addr, _lw_offset, const_lw_count, sig_spec]
//	scratch_write[_xfer, _base_lw_addr, _lw_offset, const_lw_count, sig_spec]
//	scratch_incr[_base_lw_addr, _lw_offset]
//	scratch_bset_ind[reg_xfer, position, const_addr, const_sig_spec]
//	scratch_bclr_ind[reg_xfer, position, const_addr, const_sig_spec]



// scratch_read
//		description: Read from scratch.
//		outputs:
//			_xfer			first scratch xfer reg of sequence to read to
//		inputs:
//			_base_lw_addr	base longword address
//			_lw_offset		longword offset
//			const_lw_count	longword count
//			sig_spec		pend:  waiting on signal, context swap
//							sig:   requesting signal, but continuing
//							nosig: not requesting signal, continuing
//
//
#macro	scratch_read[_xfer, _base_lw_addr, _lw_offset, const_lw_count, sig_spec]
#if (isnum(sig_spec))
	scratch[read, _xfer, _base_lw_addr, _lw_offset, const_lw_count]
#else
	scratch[read, _xfer, _base_lw_addr, _lw_offset, const_lw_count], sig_spec
#endif
#endm


// scratch_write
//		description: Write to scratch.
//		outputs:
//			_xfer			first scratch xfer reg of sequence to write from
//		inputs:
//			_base_lw_addr	base longword address
//			_lw_offset		longword offset
//			const_lw_count	longword count
//			sig_spec		pend:  waiting on signal, context swap
//							sig:   requesting signal, but continuing
//							nosig: not requesting signal, continuing
//
#macro	scratch_write[_xfer, _base_lw_addr, _lw_offset, const_lw_count, sig_spec]

#if (isnum(sig_spec))
	scratch[write, _xfer, _base_lw_addr, _lw_offset, const_lw_count]
#else
	scratch[write, _xfer, _base_lw_addr, _lw_offset, const_lw_count], sig_spec
#endif
#endm


// scratch_incr
//		description: Write to scratch.
//		inputs:
//			_base_lw_addr	base longword address
//			_lw_offset		longword offset
//
#macro	scratch_incr[_base_lw_addr, _lw_offset]
	scratch[incr, --, _base_lw_addr, _lw_offset, 1]
#endm



// scratch_bset_ind
//		description: Set the bit indicated by position at scratch address const_addr, 
//		inputs:
//			reg_xfer		transfer reg to use
//			position		bit position
//			const_addr		longword address location in scratch
//			const_sig_spec	SYNC	ctx_swap
//							ASYNC	sig_done
//						    NOSYNC	(no signal)
//
#macro scratch_bset_ind[reg_xfer, position, const_addr, const_sig_spec]
.local tempa tempb
	alu[tempa, position, B-A, 1, <<5]							; invert shift amount (32 - output_port) for left indirect
	alu[--, tempa, B, 0]
	alu_shf[reg_xfer, --, B, 1, <<indirect]
	immed[tempb, const_addr]
#if (const_sig_spec == SYNC)
	scratch [bit_wr, reg_xfer, tempb, 0, set_bits], ctx_swap
#elif (const_sig_spec == ASYNC)	
	scratch [bit_wr, reg_xfer, tempb, 0, set_bits], sig_done
#else
	scratch [bit_wr, reg_xfer, tempb, 0, set_bits]
#endif

.endlocal
#endm

// scratch_bclr_ind
//		description: Clear the bit indicated by position at scratch address const_addr, 
//		inputs:
//			reg_xfer		transfer reg to use
//			position		bit position
//			const_addr		longword address location in scratch
//			const_sig_spec	SYNC	ctx_swap
//							ASYNC	sig_done
//						    NOSYNC	(no signal)
//
#macro scratch_bclr_ind[reg_xfer, position, const_addr, const_sig_spec]
.local tempa tempb
	alu[tempa, position, B-A, 1, <<5]							; invert shift amount (32 - output_port) for left indirect
	alu[--, tempa, B, 0]
	alu_shf[reg_xfer, --, B, 1, <<indirect]
	immed[tempb, const_addr]
#if (const_sig_spec == SYNC)
	scratch [bit_wr, reg_xfer, tempb, 0, clear_bits], ctx_swap
#elif (const_sig_spec == ASYNC)	
	scratch [bit_wr, reg_xfer, tempb, 0, clear_bits], sig_done
#else
	scratch [bit_wr, reg_xfer, tempb, 0, clear_bits]
#endif

.endlocal
#endm


#endif // SCRATCH_UC