//------------------------------------------------------------------------------------
//                                                                      
//                   I N T E L   P R O P R I E T A R Y                   
//                                                                       
//      COPYRIGHT (c)  1998-99 BY  INTEL  CORPORATION.  ALL RIGHTS          
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//      THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                       
//                         INTEL  CORPORATION                            
//                                                                      
//                      2200 MISSION COLLEGE BLVD                        
//                                                                       
//                SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                       
//------------------------------------------------------------------------------------
// rec_lmatch.uc
// IPV4 longest specific address match
//
//
// system: SA1200
// subsystem: IP router microcode
// usage: example
// author: dfh 9/28/97
//
// revisions:
//  dfh     Feb 28, 2000    use ip.uc macros, ip_da_extract, ip_trie5_lookup


// ---------------------------SA1200 microcode--------------------------	
//
// Prerequisite Register Usage:
//	symbol
//	 hi64k_base		  - base address of 3 adjacent tables:
//   					1. 64k entry lookup table, each entry 32 bits, total 256KB
//					 	2. 256 entry lookup table, each entry 32 bits, total 1KB 
//						3. many 16 entry trie tables, each entry  32 bits
//   route_table_base -	sdram route entries 128K x 8 longwords (1MB)
//						32 byte stride = offset must be shifted left 5
//	 ip_da			  - 32 bit IP destination address
//
//
// description:
//	Get the route entry whose ip address has the most specific match with ip_da.
//	Also known as longest-prefix match. 
//  lookup result:
//   $$route_entry0-3	- 4 longwords of route entry info,
//					      including the forwarding interface and MAC DA
// Algorithm:
//		please refer to IXP1200 Software Reference Manual (SRM)

#include "ip.uc"

.xfer_order $$xfer0 $$xfer1 $$xfer2 $$xfer3 $$xfer4 $$xfer5 $$xfer6 $$xfer7
.operand_synonym $$route_entry0 $$xfer0
.operand_synonym $$route_entry1 $$xfer1
.operand_synonym $$route_entry2 $$xfer2
.operand_synonym $$route_entry3 $$xfer3

.import_var hi64k_base route_table_base

route_lookup#:

// adding code


		#macro immed_32[reg, data1, data2]  ; allows writing 32 bits to a register
		.local reg1
		immed_w0[reg1, data1]
		immed_w1[reg1, data2]
		alu[reg, --,b,reg1]
		.endlocal
		#endm

#if ( FID == 0 )
.local ip_sa temp1 temp2 temp3 temp4 mask
// internal network code (handles packets leaving the network)
;;;;;our code commented out
	ip_sa_extract[ip_sa, BYTEOFFSET14]
	get_NAT_entry[ip_sa,temp2,temp3]
	ip_cksum_extract[temp1, BYTEOFFSET14]
	alu[temp1, --, ~B, temp1]
    alu[temp3, temp1, +, temp3]
	immed[mask, 0xffff]
	.if(temp3>mask)
		alu[temp3, temp3, and, mask]
		alu[temp3, temp3, +, 1]
	.endif
;	alu_shf[mask, --, B, 1, <<16]
;	alu[temp4, temp3, and, mask]
;	alu[temp3, temp3, +, temp4, >>16]
	alu[temp3, --, ~B, temp3]
	alu[temp3, temp3, and, mask]
	ip_nat_modify[14, temp2, temp3, 14]    //  ????????
;;;;end our code
.endlocal
#elif ( FID == 1 )
// external network code (handles packets coming back)
.local int_ip int_port cksum_d tcp_d cksum tcp temp1 temp2
	ip_da_extract[ip_da, BYTEOFFSET14]
	get_INV_entry[ip_da, int_ip, int_port, cksum_d, tcp_d]  ; still need to use int_port and tcp_d ?????
	ip_cksum_extract[cksum, BYTEOFFSET14]
	alu[cksum, --, ~B, cksum]
	alu[cksum, cksum, +, cksum_d]
	immed[mask, 0xffff]
	.if(cksum > mask)
		alu[cksum, cksum, and, mask]
		alu[cksum, cksum, +, 1]
	.endif
	alu[cksum, --, ~B, cksum]
	alu[cksum, cksum, and, mask]
	immed[mask, 0x0300]
	alu[cksum, cksum, +, mask]

	//debuggin stuff to memory
	alu[$xfer3, --, B, ip_da]
	immed[mask, 10]
	scratch[write, $xfer3, mask, 0,1], ctx_swap
	alu[$xfer3, --, B, int_ip]
	scratch[write, $xfer3, mask, 1,1], ctx_swap
	alu[$xfer3, --, B, cksum]
	scratch[write, $xfer3, mask, 2,1], ctx_swap

	ip_inv_nat_modify[14, int_ip, cksum, 14]

	//---- begin test code for tcp_checksum
	;ip_tcp_cksum_extract[old_tcp_checksum, BYTEOFFSET14]
	field_srbuf_extract[old_tcp_checksum, 14, 36, 37]
	// writing info into scratchpad
		alu[temp1, --, B, $xfer1]	// save value in $xfer1
		immed32[old_tcp_checksum, 0xaabbccdd]
		alu[$xfer1, --, B, old_tcp_checksum]
		immed[mask, 0x0023]
		scratch[write, $xfer1, mask, 0,1], ctx_swap
		alu[$xfer1, --, B, temp1]  // restore value in $xfer1
	// end of scratchpad stuff

	//---- end of test code for tcp_checksum

.endlocal
#endif



// end adding code

	ip_da_extract[ip_da, 14]									; get da. ip header starts at read xfer byte 14
	ip_trie5_lookup[route_ent_offset, ip_da, hi64k_base, 0]		; perform longest prefix match
	br!=0[ip_get_route#], guess_branch
    immed[exception, IP_NO_ROUTE]
    br[packet_discard#]

ip_get_route#:
.local temp_route_base
    immed_w0[temp_route_base, route_table_base]				; load shared address value
    immed_w1[temp_route_base, route_table_base>>16]
	

// the transfer from rfifo was done at the top of ipverify, in order to free the rfifo element earlier
// we should have the signal back well before now
//
	ctx_arb[sdram]									    ; is transfer from rfifo done?

//	Write thread done as soon as the rfifo element is transferred to sdram
//  By the time it turns around and get sot the Receive Scheduler, this thread will be done
//
#ifndef RECEIVE16						; if no receive scheduler, there are 16 receive threads
			fast_wr[3, THREAD_DONE]		; notify receive scheduler with EOP encode
#endif


//---------------------------------------------------------------------------------------
#ifdef LAYER4
// do some busywork to emulate layer 4+
	delay[8]
	sram[read, $xfer2, temp_base3, 2, 1], ctx_swap
	delay[8]
	move[$xfer0, 0]
	move[$xfer1, 1]
	move[$xfer2, 0]
	move[$xfer3, 1]
	hash2_48[$xfer0], ctx_swap						; 2 hash lookups
	delay[8]
	sram[read, $xfer2, temp_base3, 2, 1], ctx_swap
	delay[8]
	sram[read, $xfer2, temp_base3, 2, 1], ctx_swap
#endif
//---------------------------------------------------------------------------------------

// get route entry
	sdram[read, $$route_entry0, temp_route_base, route_ent_offset, 2], optimize_mem, ctx_swap
	alu[output_port, --, b, $$route_entry0]				; save output port for enqueue

.endlocal		// temp_route_base


got_output_port#:
write_layers23#:	
// modify layer 2. insert MAC DA from route entry, write first 32 bytes to sdram  
//	move[$$xfer0, $$route_entry1]							; next hop da bytes 0-3
#ifdef LITTLE_ENDIAN
	alu[$$xfer1, $$route_entry2, +, sa01, <<16]				; next hop da bytes 4-5: 0 merge with sa bytes 0-1
#else
	alu[$$xfer1, sa01, +, $$route_entry2, <<16]				; next hop da bytes 4-5: 0 merge with sa bytes 0-1
#endif
	move[$$xfer2, $xfer2]									; sa bytes 2-5
	sdram[write, $$xfer0, packet_buf_addr, 0, 4]			; write first 32 bytes of modified mpacket

.endlocal		// sa01

; rec_enqueue.uc follows

