/* uclo.h
 * uCode Loader Library
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *  system: SA1200
 *  subsystem: Linker/Loader
 *  author: drj Dec 31, 97  Initial version
 *  revisions:
 *  $History: uclo.h $
 * 
 * *****************  Version 23  *****************
 * User: Drjohns1     Date: 10/15/99   Time: 3:00p
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 22  *****************
 * User: Drjohns1     Date: 10/13/99   Time: 5:31p
 * Updated in $/dev_1200/Include
 * Updated error codes
 * 
 * *****************  Version 20  *****************
 * User: Drjohns1     Date: 6/10/99    Time: 8:59p
 * Updated in $/dev_1200/Include
 * Changed char  uEng param to int uEngMask for UcLo_WriteUword
 * 
 * *****************  Version 19  *****************
 * User: Drjohns1     Date: 6/03/99    Time: 3:33p
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 18  *****************
 * User: Drjohns1     Date: 5/06/99    Time: 5:57p
 * Updated in $/dev_1200/Include
 * Fixed fill-pattern being counted as valid uwords
 * 
 * *****************  Version 16  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 4:24p
 * Updated in $/development/uclo
 * update COPYRIGHT
 * 
 * *****************  Version 15  *****************
 * User: Drjohns1     Date: 1/22/99    Time: 2:51p
 * Updated in $/development/uclo
 * Added Uclo_CopyObjFile
 * 
 * *****************  Version 14  *****************
 * User: Drjohns1     Date: 11/23/98   Time: 4:39p
 * Updated in $/development/uclo
 * Added support for loading *.uof via PCI
 * 
 * *****************  Version 13  *****************
 * User: Drjohns1     Date: 5/21/98    Time: 2:26p
 * Updated in $/base_level2/uclo
 * Updated copyright header
 * 
 * *****************  Version 12  *****************
 * User: Johnsondes   Date: 4/13/98    Time: 5:28p
 * Updated in $/base_level2/uclo
 * Encapsulated the UOF object into seperate chunk
 * 
 * *****************  Version 11  *****************
 * User: Johnsondes   Date: 3/04/98    Time: 12:06p
 * Updated in $/base_level1/uclo
 * Defined UCLO_BADFUNCID
 * 
 * *****************  Version 10  *****************
 * User: Johnsondes   Date: 3/03/98    Time: 4:57p
 * Updated in $/base_level1/uclo
 * Renamed some functions
 * 
 * *****************  Version 9  *****************
 * User: Johnsondes   Date: 3/02/98    Time: 1:49p
 * Updated in $/base_level1/uclo
 * Renamed UcLo_MapImageAddr to UcLo_MapObjAddr
 * 
 * *****************  Version 8  *****************
 * User: Johnsondes   Date: 2/23/98    Time: 1:41p
 * Updated in $/base_level1/uclo
 * Changed Uclo_GetLabel_addr to Uclo_GetFuncAddr
 * 
 * *****************  Version 7  *****************
 * User: Johnsondes   Date: 2/20/98    Time: 8:22p
 * Updated in $/base_level1/uclo
 * Changed export_label to export_func, added functionality for
 * export_table and function args length
 * 
 * *****************  Version 6  *****************
 * User: Johnsondes   Date: 2/11/98    Time: 7:17p
 * Updated in $/base_level1/uclo
 * Added copyright and comments.  Removed utility function from loader
 * library.
 * 
 * *****************  Version 5  *****************
 * User: Johnsondes   Date: 2/10/98    Time: 4:25p
 * Updated in $/base_level1/uclo
 * On going development
 *
 * ---------------------------------------------------------------------
 */
#ifndef __UCLO_H__
#define __UCLO_H__

enum{
	UCLO_SUCCESS = 0,
	UCLO_FAILURE = 0x8200,
	UCLO_FILEFAIL,
	UCLO_BADOBJ,
	UCLO_MEMFAIL,
	UCLO_BADARG,
	UCLO_NOOBJ,
	UCLO_IMGNOTFND,
	UCLO_SYMNOTFND,
	UCLO_TABLEFULL,
	UCLO_REDEFINE
};

#define UCLO_BADFUNCID	-1


typedef struct UcLo_FuncInfo_S{
   char 		*funcName;		/* pointer function name */
   char 		funcType;		/* function type -- 1-way or 2-way */
   char			inArgBytes;		/* input arg len in bytes */
   char			outArgBytes;	/* output arg len in bytes */
   short		threadIds;		/* thread ID (byte 0, bit 0-3) */
   short		funcAddress;	/* func micro word address */
}UcLo_FuncInfo_T;


#ifdef __cplusplus
extern "C"{
#endif

void UcLo_InitLib();
int UcLo_WriteUword(unsigned int uEngMask, unsigned int uAddr, int unsigned uWord);
int UcLo_ReadUword(unsigned char uEngNum, unsigned int uAddr, unsigned int *uWord);
int UcLo_VerifyUimage(void *handle, char *ucodeImageName);
int UcLo_VerifyUengine(void *handle, int uEngNum);
int UcLo_WriteUimagePage(void *handle, char *ucodeImageName, int pageNum);
int UcLo_WriteUimage(void *handle, char *ucodeImageName);
int UcLo_WriteUimageAll(void *handle);

#ifdef UCLO_PCI
int UcLoPci_Init(void *libdHandle, int loadFuncId);
int UcLoPci_LoadUof(unsigned int destPciDevNum, int loadUofFuncId,
			unsigned int shrmpSrcId, unsigned int shrmpDestId,
			unsigned int *uofBufPtr, unsigned int uofSize);
#endif

int UcLo_DeleObj(void *handle);
int UcLo_MapObjAddr(void **handle, void *addrPtr, int memSize, int readOnly);
int UcLo_CopyObjFile(char *fileName, char **objBuf, unsigned int *chunkSize);
int UcLo_LoadObjFile(void **handle, char *fileName);
int UcLo_BindSymbol(void *handle, char *ucodeImageName, char *ucodeSymName, int value);
int UcLo_BindFunction(void *handle, char *bindName, char *ucodeImageName, char *ucodeFuncName);
int UcLo_GetUfuncId(void *handle, char *ucodeLabelName);
int UcLo_GetFuncInfo(void *handle, char *uFuncName, UcLo_FuncInfo_T *funcInfo);


#ifdef __cplusplus
}
#endif

#endif          /* __UCLO_H__ */
