/* ucld_lib.h
 * ucode linker library header
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 * system: SA1200
 * subsystem: Ucode Linker
 * author: drj Feb 9, 98 adopted from uca_lib.h
 * revisions:
 * $History: ucld_lib.h $
 * 
 * *****************  Version 4  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 4:23p
 * Updated in $/development/ucld
 * update COPYRIGHT
 * 
 * *****************  Version 3  *****************
 * User: Drjohns1     Date: 5/21/98    Time: 2:20p
 * Updated in $/base_level2/ucld
 * Updated copyright header
 * 
 * *****************  Version 2  *****************
 * User: Johnsondes   Date: 2/11/98    Time: 11:33a
 * Updated in $/base_level1/ucld
 * Changed DLL_BUILD to BUILD_LIB
 * 
 * *****************  Version 1  *****************
 * User: Johnsondes   Date: 2/10/98    Time: 6:27p
 * Created in $/base_level1/ucld
 * Initial version -- for building DLL/lib
 *
 * ---------------------------------------------------------------------
 */
#ifndef __UCLD_LIB_H
#define __UCLD_LIB_H 1

typedef enum {
    UCLD_MSG_COMMENT,
    UCLD_MSG_WARNING,
    UCLD_MSG_ERROR
} UCLD_MSG_SEVERITY;


#if defined(WIN32) && defined(BUILD_LIB) && ! defined(xactor_build)
#define CALL_CONV __cdecl
  #ifdef UCLD_EXPORT
  #define DECLSPEC __declspec(dllexport)
  #else
  #define DECLSPEC __declspec(dllexport)
  #endif
#else
#define CALL_CONV
#define DECLSPEC
#endif

typedef void (CALL_CONV *UcldMsgFunc)(char *file, int line, UCLD_MSG_SEVERITY severity, char *text);
/* Application must supply ucld_msg callback.
   file:  NULL or filename associated with message
   line:  0 or line number associated with message
   sever: Severity of message
   text:  Text of message
   Note that text points to a static area and the application may not reference
   that pointer after ucld_msg returns. I.e. if the application wants to keep
   the message beyond the return, it must first copy it to some other area.
   Note also that the text string will not reference the file/line and it
   will end with a newline.
 */
DECLSPEC UcldMsgFunc CALL_CONV
ucld_register_msg_callback(UcldMsgFunc new_callback);

/* Application calls ucld_main to invoke the assembler. */
DECLSPEC int CALL_CONV
ucld_main(int argc, char *argv[]);

#endif		/* __UCLD_LIB_H */
