/* libd.h
 * Dispatcher Library
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-2000 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *  system: SA1200
 *  subsystem: Dispatcher Library
 *  author: drj Dec 31, 97  Initial version
 *  revisions:
 *  $History: libd.h $
 * 
 * *****************  Version 25  *****************
 * User: Drjohns1     Date: 3/06/00    Time: 11:30a
 * Updated in $/dev_1200/Include
 * Bug fixes
 * 
 * *****************  Version 24  *****************
 * User: Drjohns1     Date: 3/03/00    Time: 8:04p
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 22  *****************
 * User: Drjohns1     Date: 1/27/00    Time: 5:54p
 * Updated in $/dev_1200/Include
 * Removed LIBD_COMPLETED
 * 
 * *****************  Version 20  *****************
 * User: Drjohns1     Date: 12/03/99   Time: 2:43p
 * Updated in $/dev_1200/Include
 * 
 * ---------------------------------------------------------------------
 */
#ifndef __LIBD_H
#define __LIBD_H

#include "umsg.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef enum{
  LIBD_NOFUNCID = -2,
  LIBD_ERROR = -1,
  LIBD_SUCCESS = 0,
  LIBD_ERR_COMPLETED,
  LIBD_INCOMPLETE
}ReturnType_T;

typedef enum{
	LIBD_DEST_NONE=0,
	LIBD_DEST_UENG,
	LIBD_DEST_APP,
	LIBD_DEST_PCI,
	LIBD_DEST_SERIAL
}PortType_T;


typedef enum{
	ONEWAY = 1,
	TWOWAY
}LibD_FuncType;

#define MAXARGLEN 12		/* max of 3 long words argument */



typedef struct LibD_Callout_S {
   void *reservedObjPtr;		/* private member -- don't modify */
   char  destId;				/* in: destination identification */
   char  sync;					/* in: calling mode -- SYNC or ASYNC */
   short txId;					/* out: ID of the transaction */
} LibD_Callout_T;


void *LibD_Init(void *objHandle, unsigned char sourceId);
int LibD_SetUofHandle(void *libdHandle, void *uofHandle);

void LibD_DeleHandle(void *libdHandle);

LibD_Callout_T *LibD_RegAlienCallout(void *libdHandle, unsigned char funcId, LibD_FuncType funcType,
			char *funcName, int inArgBytes, int outArgBytes);

LibD_Callout_T *LibD_RegLocalCallout(void *libdHandle, char *funcName);

int LibD_RegisterCallback(void *libdHandle, unsigned char funcId, int (*funcPtr) (void *inArg, void *outArg),
			  int inLenBytes, int outLenBytes);

int LibD_CallOut(LibD_Callout_T * func, void *inArg, void *outArg);

int LibD_Invoke(unsigned int *msg);

int LibD_Inquire(LibD_Callout_T *funcHandle, void *outArg);

int LibD_GetReply(LibD_Callout_T *funcHandle, void *outArg, unsigned int timeout);
int LibD_Wait(LibD_Callout_T *funcHandle, void *outArg);

int LibD_AssignExtDestId(PortType_T portType, unsigned int devNum, unsigned int begDestId,
					  unsigned int numOfDestId);

int LibD_GetDevNum(unsigned char destId);
int LibD_GetUThreadNum(unsigned char destId);
int LibD_IsLocalDev(unsigned char destId);
int LibD_DeAssignDestId(unsigned char destId);
int LibD_AssignUThreadId(unsigned char destId, unsigned int begUthread, unsigned int numOfUthread);
int LibD_ProcessMsgQ(void *libdHandle, int wait);

#ifdef LIBD_PCI
int LibD_GetLocalPciDevNum();
#endif

#ifdef __cplusplus
}

#endif
#endif				/* __LIBD_H */
