/* delay.h
 * Common Library
 *
 *---------------------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *---------------------------------------------------------------------------
 *
 *
 *  system: SA1200
 *  subsystem: Debug Library
 *  author: drj, Dec 2,98  Initial version
 *  revisions:
 *  $History: delay.h $
 * 
 * *****************  Version 14  *****************
 * User: Drjohns1     Date: 4/04/00    Time: 6:46p
 * Updated in $/dev_1200/Include
 * OS type check and cleanup
 *  
 * ---------------------------------------------------------------------
 */
#ifndef __DELAY_H
#define __DELAY_H

#include <time.h>
#include "ostype.h"

#if (OS == UNIX)
#ifdef __cplusplus
extern "C" {
#endif
#define DELAYMS_RES 1
void delayMs(unsigned int msec);
void delayTick(unsigned int tick);
#ifdef __cplusplus
}
#endif
#endif

#if (OS == VXWORKS)
#include <taskLib.h>
#define DELAYMS_RES (1000/CLOCKS_PER_SEC)
#define delayMs(ms) taskDelay((ms)/DELAYMS_RES)
#define delayTick(t) taskDelay((t))
#endif

#if (OS == UCOS)
#include "os.h"
#define DELAYMS_RES (1000/CLOCKS_PER_SEC)
/* prevent a delay of zero from putting the task in a perpetual sleep */
#define delayMs(ms) OSTimeDly(((ms) < DELAYMS_RES) ? 1 : ((ms)/DELAYMS_RES))
#define delayTick(t) OSTimeDly((t))
#endif

#if (OS == WIN_32)
#include<wtypes.h>
#include <winbase.h>
#define DELAYMS_RES 1
#define delayMs(ms) Sleep((ms))
#define delayTick(t) Sleep((t))
#endif
#endif		/* __DELAY_H */
