/* ambaIO.h
 *
 *------------------------------------------------------------
 *                                                                      
 *                  I N T E L   P R O P R I E T A R Y                   
 *                                                                      
 *     COPYRIGHT (c)  1998-1999 BY  INTEL  CORPORATION.  ALL RIGHTS          
 *     RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
 *     BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
 *     RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
 *     LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
 *     MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
 *     THE PRIOR WRITTEN PERMISSION OF :                                
 *                                                                      
 *                        INTEL  CORPORATION                            
 *                                                                     
 *                     2200 MISSION COLLEGE BLVD                        
 *                                                                      
 *               SANTA  CLARA,  CALIFORNIA  95052-8119                  
 *                                                                      
 *------------------------------------------------------------
 *
 * system: SA1200
 * subsystem: amba_IO
 * author: Henry Qian 09/08/98
 * revisions:
 * $History: ambaio.h $
 * 
 * *****************  Version 26  *****************
 * User: Dmwhite      Date: 2/29/00    Time: 7:53a
 * Updated in $/dev_1200/Include
 * psos' ARM compile  switch -pedantic wants no xtra ',' in enums
 * 
 * *****************  Version 24  *****************
 * User: Rdmurato     Date: 10/19/99   Time: 12:28p
 * Updated in $/dev_1200/Include
 * Add AMBAIO_ResetAllChips to fix sim_reset problem
 * 
 * *****************  Version 23  *****************
 * User: Drjohns1     Date: 9/22/99    Time: 11:11a
 * Updated in $/dev_1200/Include
 * Added ambaio reset -- allows the ambaio lib to be re-init when the
 * simulator is reset
 * 
 * *****************  Version 22  *****************
 * User: Drjohns1     Date: 8/06/99    Time: 4:37p
 * Updated in $/dev_1200/Include
 * Added delay arg to Sem_Wait
 * 
 * *****************  Version 20  *****************
 * User: Drjohns1     Date: 6/02/99    Time: 1:18p
 * Updated in $/dev_1200/Include
 * Modification per code-review
 * 
 * *****************  Version 19  *****************
 * User: Hqianx       Date: 5/06/99    Time: 5:55p
 * Updated in $/dev_1200/Include
 * #define TRUE, and FALSE.
 * 
 * *****************  Version 18  *****************
 * User: Qabuild      Date: 4/29/99    Time: 12:07p
 * Updated in $/dev_1200/Include
 * 
 * *****************  Version 15  *****************
 * User: C-tclancy    Date: 3/23/99    Time: 4:18p
 * Updated in $/development/tool/Xact_io
 * update COPYRIGHT
 * 
 * *****************  Version 14  *****************
 * User: Drjohns1     Date: 3/05/99    Time: 8:54p
 * Updated in $/development/tool/Xact_io
 * Updated for generic interrupt functions
 * 
 * *****************  Version 13  *****************
 * User: Lhui         Date: 2/26/99    Time: 9:35a
 * Updated in $/development/tool/Xact_io
 * Check-in for Desmond
 * 
 * *****************  Version 12  *****************
 * User: Drjohns1     Date: 2/24/99    Time: 6:46p
 * Updated in $/development/tool/Xact_io
 * 
 * *****************  Version 11  *****************
 * User: Drjohns1     Date: 2/22/99    Time: 2:23p
 * Updated in $/development/tool/Xact_io
 * Added enabling/disabling of fbox and breakpoint interupts
 * 
 * *****************  Version 10  *****************
 * User: Qabuild      Date: 2/18/99    Time: 12:19p
 * Updated in $/development/tool/Xact_io
 * update for comments
 * 
 * *****************  Version 9  *****************
 * User: Drjohns1     Date: 2/12/99    Time: 5:52p
 * Updated in $/development/tool/Xact_io
 * Updated for multi-chip/auto_ambio related changes
 * 
 * *****************  Version 8  *****************
 * User: Drjohns1     Date: 2/10/99    Time: 2:11p
 * Updated in $/development/tool/Xact_io
 * Fixed MULTI_CHIP compile errors
 * 
 * *****************  Version 7  *****************
 * User: Drjohns1     Date: 2/09/99    Time: 2:30p
 * Updated in $/development/tool/Xact_io
 * Updated to make ambaio read/write block until completion
 * 
 * *****************  Version 6  *****************
 * User: Drjohns1     Date: 2/05/99    Time: 7:03p
 * Updated in $/development/tool/Xact_io
 * Added support for breakpoint interupt
 * 
 * *****************  Version 5  *****************
 * User: Hqianx       Date: 12/15/98   Time: 5:27p
 * Updated in $/development/tool/Xact_io
 * simplified ambaIoTest().
 * 
 * *****************  Version 4  *****************
 * User: Lhui         Date: 11/24/98   Time: 5:49p
 * Updated in $/development/tool/Xact_io
 * Provide support for the multiple chip feature supported in the
 * Transactor.
 * 
 * *****************  Version 3  *****************
 * User: Hqianx       Date: 9/30/98    Time: 10:57a
 * Updated in $/base_level3/tool/Xact_io
 * Added function unsigned int ambaIoInitDone(void).
 * 
 * *****************  Version 2  *****************
 * User: Hqianx       Date: 9/29/98    Time: 3:41p
 * Updated in $/base_level3/tool/Xact_io
 * Added extern "C" for c code.
 * 
 * *****************  Version 1  *****************
 * User: Hqianx       Date: 9/21/98    Time: 7:09p
 * Created in $/base_level3/tool/Xact_io
 * Have an all lowcase file name.
 * 
 * *****************  Version 1  *****************
 * User: Hqianx       Date: 9/17/98    Time: 5:14p
 * Created in $/base_level3/tool/Xact_io
 * AMBA I/O API.
 */

#ifndef AMBAIO_H
#define AMBAIO_H

#include "TS.h"
#include "core_io.h"

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

/* Pointer to function with no arguments returning void */
typedef void (*PFV)(void);

const unsigned int AMBAIO_READ = 0;
const unsigned int AMBAIO_WRITE = 1;

const unsigned int AMBAIO_CALL_UNBLOCK = 0;
const unsigned int AMBAIO_CALL_BLOCK = 1;

const unsigned int AMBAIO_SRAM_BASE = 0x10000000;
const unsigned int AMBAIO_SYSTEM_BASE = 0x90000000;
const unsigned int AMBAIO_FBI_BASE = 0xB0000000;
const unsigned int AMBAIO_IREG = 0x401E0;

const unsigned int AMBAIO_FBOX_INT_ENABLE = 0x80000000;

const unsigned int BKPT_IRQ	= 0x1000000;
const unsigned int CTX_IRQ	= 0x0ffffff;

#define MAXCHIP 10



enum {
   IDLE,
   STOP,
   AMBIO_READ,
   AMBIO_WRITE
};


#ifdef __cplusplus

class AmbaIoCmd {
public:
	AmbaIoCmd(char *ChipName);
	~AmbaIoCmd();
	inline void waitBusy(){Sem_Wait(busy,SEM_WAITFOREVER);}
	inline void postBusy(){Sem_Post(busy);}
	inline void waitCmd(){Sem_Wait(sem,SEM_WAITFOREVER);}
	inline void postCmd(){Sem_Post(sem);}

	inline int read32(unsigned int addr, unsigned int *val);
	inline int write32(unsigned int addr, unsigned int val);

	inline void autoRead32(unsigned int addr);
	inline void autoWrite32(unsigned int addr, unsigned int val);
	inline void stop(void);

    inline int simTilDone(unsigned int *val);

private:
   sem_T		busy;
   sem_T		sem;
   thread_T		threadId;
   unsigned int address, data;
   int			status, cmd, isBusy;
   const char	*chipName;
   int			ambaIoCmdRdy;

   friend void	ambioCmdThread(void *inArg);
   inline int	isIdle(){return(cmd == IDLE);}
};


class  XactChip {
public:
    AmbaIoCmd	autoAmbio;
	Semaphore	ambaioAccessSemphore;

	XactChip(char *ChipName, ISR_FUNC FboxHandler = NULL);

	~XactChip(){};
	int ChipNameMatch(char *ChipName) 
	    {if (strcmp(m_ChipName, ChipName) == 0)
		return 1;
	else
		return 0;
	};
	inline ISR_FUNC GetIntFboxHandler() const {return m_intFboxHandler;}	
	inline int GetIntParam() const {return m_param;}
	int FIQ_Connect(SA1200_INTS intSrc, ISR_FUNC handler, int param);
	int IRQ_Connect(SA1200_INTS intSrc, ISR_FUNC handler, int param);
	int FIQ_Enable(SA1200_INTS intSrc);
	int IRQ_Enable(SA1200_INTS intSrc);
	int FIQ_Disable(SA1200_INTS intSrc);
	int IRQ_Disable(SA1200_INTS intSrc);

	inline int intLock(void){return(0);}
	inline void intUnlock(int prevVal){return;}

    inline int IsValid() const {return m_Valid;};

	inline char *GetChipname(void){return(m_ChipName);}
	Semaphore Interupt;
	inline int isFboxIntEn(){return(m_fboxInt);}
	inline void enIntAutoRead(){m_intAutoRead = TRUE; return;}
private:
	char		m_ChipName[120];
	ISR_FUNC	m_intFboxHandler;
	int			m_Valid, m_initThreadDone, m_intAutoRead;
	int			m_fboxInt, m_param;
	friend void initDriver(void *arg);
	friend void interuptThread(void *ctx);
};

#endif			/* __cplusplus */


#ifdef __cplusplus
extern "C" {
#endif
int AMBAIO_Read32(char *ChipName,  unsigned int address, unsigned int* data);

int AMBAIO_Write32(char *ChipName, unsigned int address, unsigned int data);

int AMBAIO_ReadIREG(char *ChipName, unsigned int* data);

int AMBAIO_WriteIREG(char *ChipName, unsigned int data);

int AMBAIO_AutoRead32(char *ChipName,  unsigned int address, unsigned int* data);

int AMBAIO_AutoWrite32(char *ChipName, unsigned int address, unsigned int data);
void AMBAIO_Reset(void);
int AMBAIO_ResetChip(char *ChipName);
int AMBAIO_ResetAllChips();

void ambaIoInit(void);
void autoAmbaIoInit(void);
void multiChip_ambaIoInit(char *ChipName);

int AMBAIO_IRQ_Connect(char *ChipName, SA1200_INTS InteruptKind, ISR_FUNC Handler, int param);
int AMBAIO_FIQ_Connect(char *ChipName, SA1200_INTS InteruptKind, ISR_FUNC Handler, int param);
int AMBAIO_FIQ_Enable(char *ChipName, SA1200_INTS InteruptKind);
int AMBAIO_FIQ_Disable(char *ChipName, SA1200_INTS InteruptKind);
int AMBAIO_IRQ_Enable(char *ChipName, SA1200_INTS InteruptKind);
int AMBAIO_IRQ_Disable(char *ChipName, SA1200_INTS InteruptKind);
void AMBAIO_intUnlock(char *ChipName, int prev_val);
int AMBAIO_intLock(char *ChipName);

int AMBAIO_InitChip(char *ChipName, ISR_FUNC handler);
void AMBAIO_EnableIntAutoRead(char *pChipName);

void ambaIoTest(void);

unsigned int ambaIoInitDone(void);

void interruptDispatcher(void* ctx, unsigned int fiqStatus, unsigned int irqStatus);

#ifdef __cplusplus
}
#endif

#endif /* AMBAIO_h */


