//------------------------------------------------------------------------------------
//                                                                      
//                   I N T E L   P R O P R I E T A R Y                   
//                                                                       
//      COPYRIGHT (c)  2000 BY  INTEL  CORPORATION.  ALL RIGHTS          
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//      THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                       
//                         INTEL  CORPORATION                            
//                                                                      
//                      2200 MISSION COLLEGE BLVD                        
//                                                                       
//                SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                       
//------------------------------------------------------------------------------------
// ether.uc
// macros for ethernet protocol header 
//
// system: IXP1200
// subsystem: IP microcode
// usage: library macros
// author: dfh	Apr 20, 2000
//
// revisions:


#ifndef ETHER_UC
#define ETHER_UC


// API:
//		ether_prot_extract[_protocol_len, const_srbuf_ether_start]
		

#define ETHER_MTU 1500			// maximum ethernet packet size


// ether_prot_extract
// 		description: Extract protocol length field from bytes 12-13 of an ethernet header.
//					 If little-endian source, swap output bytes.
//		outputs:
//			protocol_len				protocol length field, big-endian
//		inputs:
//			const_sxfer_ether_start		starting byte of ethernet header, from start of packet
//		size: 1 instr (big-endian), 2 instr (little-endian)
//		see also: field.uc, endian.uc
//		example usage:
//			ether_prot_extract[prot_len, BYTEOFFSET0]
//
#macro ether_prot_extract[_protocol_len, const_srbuf_ether_start]
	field_srbuf_extract[_protocol_len, const_srbuf_ether_start, 12, 13]
#endm


#endif // ETHER_UC
