//------------------------------------------------------------------------------------
//                                                                      
//                   I N T E L   P R O P R I E T A R Y                   
//                                                                       
//      COPYRIGHT (c)  1998-99 BY  INTEL  CORPORATION.  ALL RIGHTS          
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//      THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                       
//                         INTEL  CORPORATION                            
//                                                                      
//                      2200 MISSION COLLEGE BLVD                        
//                                                                       
//                SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                       
//------------------------------------------------------------------------------------
// rec_nextpac.uc
// get packet from receive FIFO, parse data link, ip version and
// make bridge/route/zero_protocol decision
// this version assumes element rfifo entry = thread id
//
// Version = 1.0.NoBldNum
//
// system: SA1200
// subsystem: receive microcode
// usage: layer 2 header
// author: dfh 11/8/97
// revisions:
//		dfh		7/1/98		support FAST PORT
//		dfh		7/29/98		remove #ifdef REC_SCHEDULER2
//		dfh		7/31/98		test for cancel first, remove message type jump
//		dfh		1/12/99		bi-endian. lower level macros perform swaps if #define LITTLE_ENDIAN

#macro Rx_CreateIndividualReq_F[receive_req, tid]
#ifdef FAST_PORT1
	alu_shf[receive_req, --, B, 1, <<16]				; insert seq_field (fast port) into this receive request
	alu[receive_req, receive_req, OR, FAST_PORT1]			; mac id
#else
#ifdef FAST_PORT2
	alu_shf[receive_req, --, B, 2, <<16]				; insert seq_field (fast port) into this receive request
	alu[receive_req, receive_req, OR, FAST_PORT2]			; mac id
#endif ; FAST_PORT2
#endif ; FAST_PORT1
	alu[receive_req, receive_req, OR, tid, <<6]		; wakeup thread id
	alu[receive_req, receive_req, OR, tid, <<18]	; element no.
#endm


.operand_synonym protocol_len tempb
.operand_synonym exception tempb

.xfer_order $xfer0 $xfer1 $xfer2 $xfer3 $xfer4 $xfer5 $xfer6 $xfer7
.xfer_order $$xfer0 $$xfer1 $$xfer2 $$xfer3 $$xfer4 $$xfer5 $$xfer6 $$xfer7
.operand_synonym $new_descriptor $xfer6
.operand_synonym $sequence_num $xfer5

    // calculate the thread id of the thread that this thread will signal 
#ifdef ODD
#define TARGET_TID_CTX0 (FID*4 - 4)
#define TARGET_TID_CTX1 (FID*4 - 3)
#define TARGET_TID_CTX2 (FID*4 - 2)
#define TARGET_TID_CTX3 (FID*4 - 1)
#else
#define TARGET_TID_CTX0 (FID*4 + 5)
#define TARGET_TID_CTX1 (FID*4 + 6)
#define TARGET_TID_CTX2 (FID*4 + 7)
#define TARGET_TID_CTX3 (FID*4 + 4)
#endif



// setup rfifo_entry and port based on thread_id. each thread works on a fixed element
// thread 0 works on receive fifo element 0
// thread 11 works on receive fifo element 11
	br=ctx[0, context0#]
	br=ctx[1, context1#]
	br=ctx[2, context2#]
	br=ctx[3, context3#]

context0#:
	alu_shf[rfifo_entry, --, B, CONTEXT0_TID, <<3]		; form starting quadword address in rfifo
	Rx_CreateIndividualReq_F[receive_req, CONTEXT0_TID]

	//initialize seq_num = 1 if FID is odd, and 2 if FID is even.
.local temp
#ifdef ODD
	alu[temp, --, b, 1]
	alu[@seq_num, --, b, temp]
#else
	alu[temp, --, b, 2]
	alu[@seq_num, --, b, temp]
#endif
.endlocal

#ifdef FAST_PORT1
	immed[tempb, SRAM_MPACKET_MAILBOX_1]
#endif
#ifdef FAST_PORT2
	immed[tempb, SRAM_MPACKET_MAILBOX_2]
#endif
	alu[$xfer2, --, B, 1, <<31]						; set valid bit
	sram[write, $xfer2, tempb, 2, 1]				; write to validate slot 1 mailbox, since first mseq =1

	// Increment the sequence number if fbox id is 0 or 2.
.local temp
	alu[temp, --, b, FID]
	alu[temp, temp, and, 1]
	br!=0[skip_this_init#]
#ifdef FAST_PORT1
		fast_wr[3, INCR_ENQ_NUM1]								; increment fast port 1 seq number
#else
#ifdef FAST_PORT2
		fast_wr[3, INCR_ENQ_NUM2]								; increment fast port 2 seq number
#endif ; FAST_PORT2
#endif ; FAST_PORT1
.endlocal
skip_this_init#:

	sem_flip[@req_inflight]								; initialize variable 

	ctx_arb[inter_thread]								; wait for the hardware to be initialized by hw_init

	#ifdef EVEN
		fast_wr[TARGET_TID_CTX0, inter_thd_sig]			; signal thread to send rcv_req - get things started
	#endif

	br[begin#]

context1#:
	alu_shf[rfifo_entry, --, B, CONTEXT1_TID, <<3]		; form starting quadword address in rfifo
	Rx_CreateIndividualReq_F[receive_req, CONTEXT1_TID]
	br[begin#]

context2#:
	alu_shf[rfifo_entry, --, B, CONTEXT2_TID, <<3]		; form starting quadword address in rfifo
	Rx_CreateIndividualReq_F[receive_req, CONTEXT2_TID]
	br[begin#]

context3#:
	alu_shf[rfifo_entry, --, B, CONTEXT3_TID, <<3]		; form starting quadword address in rfifo
	Rx_CreateIndividualReq_F[receive_req, CONTEXT3_TID]



begin#:

// load hash multiplier
// for debugging, set to 1
// (alternatively this can be done in core)
#ifdef BRIDGE
	move[$xfer0, 0]
	move[$xfer1, 1]
	csr[write, $xfer0, HASH_MULTIPLIER_48_HI]
	csr[write, $xfer1, HASH_MULTIPLIER_48_LO]
#endif



next_packet#:

	
	ctx_arb[inter_thread]		; wait for signal from other receive fbox indicating it is our turn to request

	sem_wait[@req_inflight]

.local seq_num
	alu[seq_num, --, b, @seq_num]
	alu[$xfer0, receive_req, OR, seq_num, <<22]
	alu[seq_num, seq_num, +, 2]							; 2 fboxes are processing this fast port, so add 2
	alu[seq_num, seq_num, AND, 0xf]
	alu[@seq_num, --, b, seq_num]
.endlocal

	csr[write, $xfer0, rcv_req]							; send req to FBI

	sem_flip[@req_inflight]								; set to block other contexts from sending rec_req

	//signal next thread to request a packet
	br=ctx[0, thread0#]
	br=ctx[1, thread1#]
	br=ctx[2, thread2#]

	
	fast_wr[TARGET_TID_CTX3, inter_thd_sig]		;thread 3 processing
	br[signal_sent#]
thread0#: 										;thread 0 processing
	fast_wr[TARGET_TID_CTX0, inter_thd_sig]
	br[signal_sent#]
thread1#: 										;thread 1 processing
	fast_wr[TARGET_TID_CTX1, inter_thd_sig]
	br[signal_sent#]
thread2#: 										;thread 2 processing
	fast_wr[TARGET_TID_CTX2, inter_thd_sig]

signal_sent#:

// get a packet descriptor while waiting to start
// tempa is there only to make assembler happy
//
	alu[--, --, b, skip_pop]							; if last packet was canceled, then use that packet's buffer
	br!=0[next_packet_sop#]
	sram[pop, $new_descriptor, tempa, 0, PACKET_FREELIST], sig_done

next_packet_sop#:

// Load the receive_control_register
//
// format of RCV_CTL is
// +-----+-----+-----+------+----+-----+-----+----+----+-----------+---+---+
// | msg |port |seq# |rxfail|err |elem2|elem1|1or2|seq | validbytes|EOP|SOP|
// |31:30|29:24|23:20|  19  | 18 |17:14|13:10| 9  | 8  |    7:2    | 1 | 0 |
// +-----+-----+-----+------+----+-----+-----+----+----+-----------+---+---+
//
	Rx_Receive[$xfer7, packet_cancel#, packet_fail_discard#]	; read and check receive control

	alu_shf[rec_state, $xfer7, AND, 0xf, <<20]			; put FAST PORT sequence# in rec_state	23:20


// save FAST PORT info
//
fast_port_rec_state#:
    br_bclr [$xfer7, 0, fast_not_sop#], defer[2]		; check for continuation packet
	ld_field[rec_state, 0001, $xfer7]					; byte count, eop, sop from rcv_cntl 7:0 to 7:0
	alu_shf[rec_state, rec_state, OR, 1, <<30]			; FAST source PORT rec_state 30 = 1

	alu_shf[tempb, 0x1e, AND, $xfer7, >>13]				; get mpacket sequence

	alu[--, $xfer7, AND, 1, <<1]						; test EOP
	br=0[read_rfifo1#]									; if not EOP, state will be saved later
	Rx_ValidateNextFastState[tempb]						; validate the next (this = SOP AND EOP)


// Load first 4 longwords of packet from the receive fifo 
// packet must be big-endian
// The first 6 bytes are dest address, then 6 bytes of source address.  
// The next 2 bytes are length(802.3) or PID (ethernet).
// If Ethernet/802.3 the next byte is network layer protocol identifier  
//
read_rfifo1#:


#ifdef ALT_BANKS
    r_fifo_rd [$xfer0, rfifo_entry, 0, 2], ctx_swap, defer[1]
	alu[rec_state, rec_state, OR, PACKET_FREELIST, <<29]	; insert freelist id
#else
    r_fifo_rd [$xfer0, rfifo_entry, 0, 2], ctx_swap
#endif

#ifdef RECEIVE16
	sem_flip[@req_inflight]								; clear to allow other context to send rec req
#endif


	alu[--, --, b, skip_pop]			; if last packet was canceled, then the pop is already complete
	br!=0[802_3_ethernet#]
	ctx_arb[sram]						; should have descriptor from rec_nextpac pop by now

802_3_ethernet#:


set_buf_addrs#:
// set packet_buf_addr and buf_handle
//
	Rx_SetBufAddrs[packet_buf_addr, buf_handle, $new_descriptor]

	alu[skip_pop, --, b, 0]								; we are using the buffer, so clear flag

fast_test_for_clear#:

// fast sop save state
fast_save1#:
	alu[--, rec_state, AND, 1, <<1]						; test EOP
	br>0[fast_invalidate_current#]						; if EOP, next was validated earlier
	Rx_SaveFastState[buf_handle, rec_state, tempb]		; non EOP, save state to next mpacket

fast_invalidate_current#:
	Rx_TestAndInvalidateFastState[tempb]				; invalidate current on SOP, var size packets


protocol_decode#:

// extract protocol length field
//
	extract_field[protocol_len, $xfer3, 0, 1]			; get bytes 0-1



// for testing purposes, a 0 in protocol_len indicates that the output port is the following byte
//
#ifdef ZERO_PROTOCOL
	br=0[rec_zeroprotocol#], defer[1]
#endif
 
 
     
// make 802.3/ethernet decision from protocol/len field
//
    immed [tempa, 1500]
    alu [--, protocol_len, -, tempa]					; compare with constant 1500 (RFC 1122, 2.3.3)
    br<=0 [parse_802_3#]								; if protocol_len is gtr than 1500, it is Ethernet




//	register usage at this point
//
//	$xfer0 					MAC DA<31:0>
//	$xfer1					MAC  DA<48:32> and SA<15:0> 
//	$xfer2					MAC  SA<31:0>  
//	$xfer3					MAC length and ip version, IHL, TOS
//	protocol_len			datalink payload length
//	packet_buf_addr			address of buffer in sdram  where packet will be stored
//	buf_handle				address offset of the current descriptor
//	rec_state					<31>fastport flag, <23:20>packet sequence number, <15:8>byte enables, eop, sop



// Ethernet bridge/route decision.
// note: this is simplified so as not to obscure the general control concepts of the ref design
//		
// check pkt word 4 byte 2 (version, IHL). if ip with no options, route, otherwise bridge
//
ethernet#:

#ifdef ROUTE
    br_eq_field[$xfer3, 2, 2, 0x45, ip_verify#]			; bridge/route decision
#endif

#ifdef BRIDGE
	br[rec_bridge#]										; if not IP continue with layer 2 bridge.
#endif

parse_802_3#:
	immed[exception, PROT802_3_NOT_IMPLEMENTED]
	br[packet_early_discard_pop_completed#]

// discard before transfer of packet data to sdram
// caused by rxfail, treated like EOP
//
packet_fail_discard#:
// the packet is dropped, bump a mib counter here
//
	alu[--, --, b, skip_pop]							; if skip_pop is still set, then we had 2 discards in a row!
	br!=0[packet_early_discard_pop_completed#]
	ctx_arb[sram]										; wait for pop to complete


packet_early_discard_pop_completed#:
	alu[skip_pop, --, b, 1]								; don't pop next time around. reuse the buffer popped this time

	immed[tempa, EXCEPTION_COUNTERS]					; 11 contexts, 16 locations each
	alu[tempa, tempa, +, rfifo_entry, <<1]				; add context id * 16
	scratch[incr, --, tempa, exception, 1]

	immed[tempa, TOTAL_DISCARDS]
	scratch[incr, --, tempa, 0, 1]


fast_rxfail_discard#:
//TBD
// if not sop rxfail, we also need to
// 1. restore state
// 2. push the relative buf address  in buf_handle back

	alu_shf[tempb, 0x1e, AND, $xfer7, >>13]				; get mpacket sequence, x2
	Rx_InvalidateFastState[tempb]						; $xfer0 contains buf_handle
	alu_shf[tempa, 0xf, AND, $xfer7, >>20]				; extract seq number
	Rx_ValidateNextFastState[tempa]						; validate next fast state

#ifdef RECEIVE16										; flip now that fast state has been updated
	sem_flip[@req_inflight]								; clear to allow other context to send rec req
#endif

	// push the buffer that we were using, if any, onto freelist
	alu[tempa, --, b, buf_handle, >>16]					; get offset
	alu[tempa, tempa, -, 1]
	br=0[skip_push#], defer[1]							; if no buffer there, then skip push

	immed32[buf_descriptor_base, SRAM_BUFF_DESCRIPTOR_BASE]
	sram[push, --, tempa, buf_descriptor_base, PACKET_FREELIST]

skip_push#:

	alu_shf[tempa, 0xf, AND, rec_state, >>20]				; extract sop seq number

#ifdef FAST_PORT1
	FastPort_SeqCheck[ENQUEUE_SEQ1, tempa]				; wait for my seq no. to come up
	fast_wr[3, INCR_ENQ_NUM1]							; increment fast port 1 seq number
#else
#ifdef FAST_PORT2
	FastPort_SeqCheck[ENQUEUE_SEQ2, tempa]				; wait for my seq no. to come up
	fast_wr[3, INCR_ENQ_NUM2]							; increment fast port 2 seq number
#endif ; FAST_PORT2
#endif ; FAST_PORT1

	br[next_packet#]									; if slow port get next packet



// discard after transfer of packet data to sdram and after loading more header into xfer regs
//
packet_discard#:
// the packet is dropped after some data has been transfered to sdram

	ctx_arb[sdram]										; take the sdram signal

// discard after sdram signal (from rfifo to sdram) has been consumed and thread_done sent
//
packet_late_discard#:

// increment exception counters
//
	immed[tempa, EXCEPTION_COUNTERS]					; 11 contexts, 16 locations each
	alu[tempa, tempa, +, rfifo_entry, <<1]				; add context id * 16
	scratch[incr, --, tempa, exception, 1]

	immed[tempa, TOTAL_DISCARDS]
	scratch[incr, --, tempa, 0, 1]

// recover full address of buffer descriptor, push back to freelist
//
.local descriptor_addr descriptor_base
	immed[descriptor_base, SRAM_BUFF_DESCRIPTOR_BASE]
	alu[descriptor_addr, descriptor_base, +, buf_handle, >>16]
	alu[descriptor_addr, descriptor_addr, -, 1]

	alu[skip_pop, --, b, 1]									; The buffer popped will be used for the next packet

.endlocal


fast_discard#:
	alu_shf[tempa, 0xf, AND, rec_state, >>20]				; extract sop seq number
#ifdef FAST_PORT1
	FastPort_SeqCheck[ENQUEUE_SEQ1, tempa]					; wait for my seq no. to come up
	fast_wr[3, INCR_ENQ_NUM1]								; increment fast port 1 seq number
#else
#ifdef FAST_PORT2
	FastPort_SeqCheck[ENQUEUE_SEQ2, tempa]					; wait for my seq no. to come up
	fast_wr[3, INCR_ENQ_NUM2]								; increment fast port 1 seq number
#endif ; FAST_PORT2
#endif ; FAST_PORT1

	.if (bit(rec_state, 1) == 0)							; if not EOP
		// fast port non-EOP discard
		alu_shf[rec_state, rec_state, OR, 1, <<19]			; set discard bit
		Rx_SaveFastState[buf_handle, rec_state, tempb]		; save state to next mpacket
	.endif

#ifdef RECEIVE16										
	sem_flip[@req_inflight]									; clear to allow other context to send rec req
#endif



	br[next_packet#]

// fast port cancel
// this receive control is skipped, because fbi found fast port not ready
// receive control message = 3
//
packet_cancel#:

	alu[--, --, b, skip_pop]							; if skip pop is still set, then we got 2 cancels in a row!
	br!=0[packet_cancel_no_buf#]
	ctx_arb[sram], defer[1]								; wait for pop to complete
	alu[skip_pop, --, b, 1]								; don't pop next time around

packet_cancel_no_buf#:
	Rx_RestoreFastState[buf_handle, rec_state]			; get state from previous mpacket
	alu[tempb, 0x1e, AND, $xfer7, >>13]					; get mseq num
	Rx_SaveFastState[buf_handle, rec_state, tempb]		; save state to next mpacket

#ifdef RECEIVE16										; flip now that fast state has been updated
	sem_flip[@req_inflight]								; clear to allow other context to send rec req
#endif

	br[next_packet#]




#ifdef ZERO_PROTOCOL
rec_zeroprotocol#:
// for mac protocol/len = 0, output port is the first byte of payload
// store_data# is in rec_enqueue, no lookup just move the data
//
	merge_extract2[rec_state, $xfer3]				; insert byte 2 output port to rec_state byte 3
	alu[output_port, 0, +8, rec_state]				; put output_port in rec_state

	.if (bit(rec_state, 31) ==1)					; if fast port
sop_save2#:
		alu[tempb, 0xf, AND, rec_state, >>20]		; get SOP seq number
		Rx_SaveOutPort[output_port, tempb]			; save output_port for EOP thread to pick up
	.endif

	br[store_data#]
#endif


