
//------------------------------------------------------------------------------------
//                                                                      
//                   I N T E L   P R O P R I E T A R Y                   
//                                                                       
//      COPYRIGHT (c)  1998-99 BY  INTEL  CORPORATION.  ALL RIGHTS          
//      RESERVED.   NO  PART  OF THIS PROGRAM  OR  PUBLICATION  MAY      
//      BE  REPRODUCED,   TRANSMITTED,   TRANSCRIBED,   STORED  IN  A    
//      RETRIEVAL SYSTEM, OR TRANSLATED INTO ANY LANGUAGE OR COMPUTER    
//      LANGUAGE IN ANY FORM OR BY ANY MEANS, ELECTRONIC, MECHANICAL,    
//      MAGNETIC,  OPTICAL,  CHEMICAL, MANUAL, OR OTHERWISE,  WITHOUT    
//      THE PRIOR WRITTEN PERMISSION OF :                                
//                                                                       
//                         INTEL  CORPORATION                            
//                                                                      
//                      2200 MISSION COLLEGE BLVD                        
//                                                                       
//                SANTA  CLARA,  CALIFORNIA  95052-8119                  
//                                                                       
//------------------------------------------------------------------------------------
// rec_ipverify.uc
// IPV4 verify the ip header prior to routing decision
//
//
// system: SA1200
// subsystem: IP route microcode
// usage: example
// author: dfh 11/8/97
//	
// revisions:
//		dfh		1/12/99		bi-endian. lower level macros perform swaps if #define LITTLE_ENDIAN
//		dfh		3/31/00		use ip.uc macros
//
// ---------------------------SA1200 microcode--------------------------	

 

// Prerequisite: 
//	rec_nextpac.uc   has executed
//	first 4 longwords of the packet has been read in from reveive FIFO
//

//	register usage at this point
//
//	$xfer0 					MAC DA<31:0>
//	$xfer1					MAC  DA<48:32> and SA<15:0> 
//	$xfer2					MAC  SA<31:0>  
//	$xfer3					MAC length and ip version, IHL, TOS
//	protocol_len			datalink payload length
//	packet_buf_addr			address of buffer in sdram where packet will be stored
//	buf_handle				address offset of the current descriptor
//	rec_state				fastport flag, packet sequence number, byte enables, eop, sop

// 
#include "ip.uc"								; ip macros

// cause insertion of FIREWALL code
//
//#ifndef FIREWALL
#define FIREWALL
//#endif

ip_verify#:
.local sa01 ip_prot ip_sa ip_source_port ip_dest_port arrayAccess
immed[ip_prot, 0] ; this acts as a flag to prevent the real ipverify code being run multiple times

ip_verify2#:

// move second 4 quadwords of receive fifo element to sdram 
//
	sdram_r_fifo_rd[packet_buf_addr, rfifo_entry, 4, 4, ASYNC]		; (see stdmac.uc)


read_rfifo2#:
// get the next 6 longwords of the packet from the receive FIFO
// continuing from where layer 2 left off, and wrapping
//
    r_fifo_rd[$xfer4, rfifo_entry, 2, 2]
#ifdef LITTLE_ENDIAN
	alu[sa01, 0, +16, $xfer1, >>16]
#else
	alu[sa01, 0, +16, $xfer1]										; save sa bytes 0-1 for later merge
#endif
    r_fifo_rd[$xfer0, rfifo_entry, 4, 1], ctx_swap

	ip_verify[exception, 14]					; ip header starts at byte 14
	br>0[packet_discard#]
	ctx_arb[voluntary]
	ip_modify[14, 14]
#ifdef FIREWALL
	alu[--,--,B,ip_prot]
	br!=0[firewall_ok#] ;if we've already run the firewall code, just jump past it.
#endif
	

ip_ok#:

// ***********************************************************************************************
// *  HBHANOO
// * 
// *  Now that we're okay, _and_ we have the packet loaded into memory,
// *  go ahead and run the firewall code. In general, here's the algorithm:
// *  
// * 
// * 1) Extract all relevant information
// * 2) Lookup the entry in the policy table
// * 	 If found -> continue.
// * 	 If not found, add to the cache and request a policy lookup from the control plane
// * 3) Increment counter for this flow
// * 4) (If this is the last packet in a TCP flow, remove the cache entry)
// * 5) Check the rules
// * 6) Drop/Pass based on the rules.
// * 
// **********************************************************************************************

#ifdef FIREWALL
ip_da_extract[ip_da,14]  ;// -------------------------  B E G I N  F I R E W A L L  C O D E -------------------------------------------


// insert code here to check if the the packet is for us. (PETH STUFF!)


ip_prot_extract[ip_prot,14]     //extract ip protocol
ip_sa_extract[ip_sa,14]         //extract ip source address
ip_source_port_extract[ip_source_port,14]    //extract ip source port
ip_dest_port_extract[ip_dest_port,14]	//extract dest port; get da. ip header starts at read xfer byte 14


// *  HBHANOO
// *  Step two in the firewall: go through the flow cache 
// *  and see if there are any matches.
// * 
// *  Here's what the cache looks like:
// * 
// *  char bitvector; (1 byte)
// *  char protocol; //(1 byte)
// *  short int counter; //(2 bytes) - packet counter.
// * 
// *  int src_addr; //(4 bytes)
// *  int dst_addr; //(4 bytes)
// * 
// *  short int src_port; //(2 bytes)
// *  short int dst_port; //(2 bytes)
// * 
// *  int string_ptr; //(4 bytes) - ptr to the string we want to search for in memory
// *  int func_ptr; //(4 bytes) - ptr to the function we give the string to, to search
// *    //for in the packet
// * 
// *  used for chaining the hash table:
// *  int next; (4 bytes) 
// *  int prev; (4 bytes) 

.local compare



// The hash multiplier tells the has unit which bits to use from the input when hashing.
// We want this set to FFFF so that all the bits are used...


immed[$xfer7, 0x0ffff]
csr[write,$xfer7, hash_multiplier_64_lo], ctx_swap
csr[write,$xfer7, hash_multiplier_64_hi], ctx_swap


// *  in order to use hashing, first create a tuple containing the appropriate
// *  information to hash on. After that, traverse through the rest of the list to 
// *  find the appropriate entry.
// * 
// *  Note: only the src and dst address are being used to perform the hash. Although
// *  		 this may not be ideal - it means that we can use the hash_64 function trivially,
// * 		 and without complication. Since we're handling hash collisions anyways, it shouldn't
// * 		 affect performance toooo much.


alu[$xfer4, --, B, ip_sa]

alu[$xfer5, --, B, ip_da]
hash1_64[$xfer4], ctx_swap

// we should now have hashed values in $xfer0/$xfer1. Let's
// just use the 16 LSBs of $xfer0 to access our array.
.local policyCacheBase
immed[policyCacheBase, 0x2001]

alu[arrayAccess, --, B, $xfer4, <<24] 
alu[arrayAccess, --, B, arrayAccess, >>21]	;24 - 21 = 3 => size of each cache entry is 2^3=8 32bit-words wide.
alu[arrayAccess, arrayAccess, +, policyCacheBase] 
.endlocal  //policycacheBase
.local chaining hashTableHead
alu[hashTableHead, --, B, arrayAccess]

cache_lookup_begin#:
// do a read_lock ONLY if we are at the head of the hashtable
// this prevents more than one thread trying to look up the same flow at the
// same time. Not very efficient, but prevents problems during addition of
// new cache entries...

alu[--, hashTableHead, XOR, arrayAccess]
br=0[lookup_lock#];lock if we're at the head
sram[read, $xfer4, arrayAccess, 0x0, 1], ctx_swap ;else just do a regular read
br[lock_done#]

lookup_lock#:
sram[read_lock, $xfer4, arrayAccess, 0x0, 1], ctx_swap ;actual locking


lock_done#:
alu[controlWord, --, B, $xfer4]


// if nothing exists at this hash position, we're done - no match!
alu_shf[compare, --, B, controlWord, >>31] ; the MSB of the 1st byte is 1 if this entry is in use
br=0[add_entry_to_cache#], defer[1] ; no entries at all, so add entry to cache...
alu[chaining,--,B, 0x0]

alu[chaining,--,B,0x1]

// now try to match the entry, else proceed in the chain (if it exists)

alu_shf[compare, 0x0, +8, controlWord, >>16]; compare = 2nd MSByte = protocol

alu[compare, compare, XOR, ip_prot]; compare protocol fields...
br!=0[cache_lookup_fail#]

sram[read, $xfer5, arrayAccess, 0x1, 3], ctx_swap; load the src/dst address and ports

// compare the source addresses:

alu[compare, ip_sa, XOR, $xfer5]
//if the match was INCORRECT, we'll get a nonzero answer
// so branch
br!=0[cache_lookup_fail#]

// compare the destination addresses:
alu[compare, ip_da, XOR, $xfer6]
//if the match was INCORRECT, we'll get a nonzero answer
// so branch
br!=0[cache_lookup_fail#]

// port information only makes sense IF
// the packet is either UDP or TCP
// so check what the protocol is:
alu[--, ip_prot, XOR, 0x6]
br=0[check_ports#]
alu[--,ip_prot, XOR, 0x11]
br!=0[skip_ports#]

// create a combination of the port info:
check_ports#:
.local ports
alu_shf[ports, 0x0, +, ip_source_port, <<16]
alu[ports, ip_dest_port, OR, ports]

alu[compare, ports, XOR, $xfer7]
//if the match was INCORRECT, we'll get a nonzero answer
// so branch
br!=0[cache_lookup_fail#]
.endlocal //ports

skip_ports#:
// if we reached this far, then all of our TUPLES matched.
// now we have to deal with extended features, and then
// deal with a rule match.

sram[unlock, --, hashTableHead, 0, 1]
br[rule_match#]






cache_lookup_fail#:
// *****
// come here if any portion of the lookup fails 
//	ie. advance in the chain until we reach the end.
// *****


sram[read, $xfer5, arrayAccess, 6, 1],ctx_swap ; read in the pointer....

alu[compare, $xfer5, XOR, 0x0]; if the 'next' pointer is NULL, 
br=0[add_entry_to_cache#] ; then we need to add this flow to the cache...

alu[arrayAccess, 0x0, B, $xfer5]; else, update the address with the 'next' pointer
br[cache_lookup_begin#]





add_entry_to_cache#:
// *****
// * we reached the end of the cache without a successful match.
// *****
// *
// * Here we have to enter code to chain this entry on to the 
// * end of the hash table using our 'freelist'.
// * we fill in all the required parameters for the flow, except
// * for the bitvector conatining the decision of the policy lookup.
// * 
// * Then we pass this information up to the control plane. The control
// * plane (StrongARM) then does the lookup of this policy and replies
// * to us when it has filled in the fields. At that point, we should be
// * able to continue by checking the result of the policy.

.local memaddr

addCacheEntry[memaddr, arrayAccess, chaining]
alu[arrayAccess, --, B, memaddr]

.endlocal //memaddr

// * arrayAccess now contains the address of the NEW entry.
// * 
// * ask the control plane to look this entry up...

// each context is assigned two addresses:
// one for a 'function code', and one for
// a 'parameter'

.local pollingAddress
.local tempaddition
immed[pollingAddress, 0x1FF, <<8]
immed[tempaddition, 0xE0]
alu[pollingAddress, pollingAddress, +, tempaddition]
.endlocal //tempaddition
#define_eval CONTEXT0_OFFSET (FID*8)
#define_eval CONTEXT1_OFFSET (FID*8+2)
#define_eval CONTEXT2_OFFSET (FID*8+4)
#define_eval CONTEXT3_OFFSET (FID*8+6)
// context 
br=ctx[1,poll_loc1#]
br=ctx[2,poll_loc2#]
br=ctx[3,poll_loc3#]

br[start_poll#], defer[1]
alu[pollingAddress, pollingAddress, +, CONTEXT0_OFFSET]

poll_loc1#:
br[start_poll#], defer[1]
alu[pollingAddress, pollingAddress, +, CONTEXT1_OFFSET]

poll_loc2#:
br[start_poll#], defer[1]
alu[pollingAddress, pollingAddress, +, CONTEXT2_OFFSET]

poll_loc3#:
br[start_poll#], defer[1]
alu[pollingAddress, pollingAddress, +, CONTEXT3_OFFSET]

start_poll#:
// at this point, we should know the correct polling address
sram[read, $xfer5, pollingAddress, 0, 1], ctx_swap
// verfiy that it is free:
alu[--,--,B,$xfer5]
br!=0[start_poll#] ; if, for some reason, the address is nonzero, WAIT.
alu[$xfer6, --, B, arrayAccess]; setup the parameter (the location of our flow cache)
alu[$xfer5, --, B, 0x1]; setup the function type
sram[write, $xfer5, pollingAddress, 0, 2], ctx_swap

wait_for_lookup#:
nop; just 
nop; adding
nop; some
nop; delay
nop; to
nop; give
nop; the 
nop; strongarm
nop; time to do a 
nop; policy
nop; lookup.
sram[read, $xfer5, pollingAddress, 0, 2], ctx_swap
alu[--, --, B, $xfer5]
br!=0[wait_for_lookup#], guess_branch

.endlocal //pollingAddress

// so now that they've done the lookup (wohoo!)
// make sure we UNLOCK the hash table head so that some other dudes
// can do a flow lookup....
sram[unlock, --, hashTableHead, 0, 1]
// * now read the first 32bit word into $xfer4 so that
// * we are consistent with the assumptions of the remaining code...
sram[read_lock, $xfer4, arrayAccess, 0x0, 1], ctx_swap
sram[unlock, --, arrayAccess, 0x0,1]
.endlocal //chaining hashTableHead


rule_match#:
//alu[arrayAccess, arrayAccess, -, 0x1]; ---HACK---
//br[check_permit#] ; ---HACK---
// * 
// * So if we made it this far, that means that we passed
// * all of the tests.
// *  
// * In this case, we have a match, and need to apply
// * the appropriate rule.
// * Note: 
// *  o first update the counter for this flow...
// *  o then remove this flow from the cache if it is
// *    the last packet in a TCP session (approximation)
// * 
// *  $xfer0 still contains the initial 32bit word, of which 
// *   the MSByte looks like this:
// *  
// *  ------------------------------------
// *  |InUse|   |   |   |   |   |Log|Drop|
// *  ------------------------------------
// *     7    6   5   4   3   2   1   0
// *  

//#define DROP	1

.local counter memlocation controlBits

// update the couters for this flow...
sram[read_lock, $xfer4, arrayAccess, 0x0, 1],ctx_swap
alu_shf[compare, 0x0, B, $xfer4, >>16] //compare contains the upper word
alu[counter, 0x1, +16, $xfer4] // increment the lower word by one
alu_shf[$xfer4, counter, OR, compare, <<16] // put the two words back together.
sram[write_unlock, $xfer4, arrayAccess, 0x0, 1], ctx_swap ; write the updated info

br[check_permit#] ; hack - isolate the CACHE REMOVAL CODE













// possibly remove this entry from the cache:
alu[compare, ip_prot, -, 0x6] ;if packet isn't TCP
br!=0[check_permit#]; we're done
tcp_control_extract[compare, 14];get control bits  // (defined in ip.uc)
alu[compare, 0x11, -, compare] ;see if it's a FIN_ACK
br!=0[check_permit#]; if not, we're fine.

// *  else:
// * 
// * 
// *  Cache_entry removal code:
// *  P = previous, N = next
// *  if(P== NULL) (head)
// *  	copyCacheEntry(next, this)
// *  	freeCacheEntry(next)
// *  	this.previous = NULL
// *  else
// *  	freeCacheEntry(this)
// * 
alu[memlocation, arrayAccess, +, 0x6] ; increment by 6
sram[read, $xfer5, memlocation, 0x0, 2]

// * Now: 	$xfer5 = next
// * 		$xfer6 = previous
// * 
alu[--,--, B, $xfer6]
br!=0[cache_remove_not_head#]
// * If we're here, it means that this *is* the head of the list:
copyCacheEntrytoHead[memlocation, $xfer5]
freeCacheEntry[$xfer5]
br[check_permit#]

cache_remove_not_head#:
freeCacheEntry[memlocation]

.endlocal //counter memlocation controlBits

//immed[exception, FIREWALL_DESTROY]
//immed[exception, 0]
//immed[compare, DROP]
//alu_shf[compare, compare, AND, controlWord, >>24]
//immed[exception, FIREWALL_DESTROY]
//br[packet_discard#] ; defined in rec_nextpac.uc

//mess with packet to corrupt it, then:
//br[packet_discard#] ; defined in rec_nextpac.uc



// This means that we're A-okay. The packet is free to go.

.endlocal ; // compare

#endif // FIREWALL
all_done#:
