// ***********************************************************************************************
// * 
// * 
// * 
// * 
// * 
// * 
// *  rec_firewall.uc
// *  the firewall
//
//
// *  system: IXP1200
// *  subsystem: IP microcode
// *  usage: library macros
// *  author: hbhanoo, dec 2000
// * 
// *  revisions:
// ***********************************************************************************************

immed[RunFirewall, 0x1]

// ***********************************************************************************************
// *  HBHANOO
// * 
// *  Now that we're okay, _and_ we have the packet loaded into memory,
// *  go ahead and run the firewall code. In general, here's the algorithm:
// *  
// * 
// * 1) Extract all relevant information
// * 2) Lookup the entry in the policy table
// * 	 If found -> continue.
// * 	 If not found, add to the cache and request a policy lookup from the control plane
// * 3) Increment counter for this flow
// * 4) (If this is the last packet in a TCP flow, remove the cache entry)
// * 5) Check the rules
// * 6) Drop/Pass based on the rules.
// * 
// **********************************************************************************************
ip_da_extract[ip_da, 14]

// insert code here to check if the the packet is for us.

ip_prot_extract[ip_prot,14]     //extract ip protocol
ip_sa_extract[ip_sa,14]         //extract ip source address
ip_source_port_extract[ip_source_port,14]    //extract ip source port
ip_dest_port_extract[ip_dest_port,14]	//extract dest port; get da. ip header starts at read xfer byte 14


// *  HBHANOO
// *  Step two in the firewall: go through the flow cache 
// *  and see if there are any matches.
// * 
// *  Here's what the cache looks like:
// * 
// *  char bitvector; (1 byte)
// *  char protocol; //(1 byte)
// *  short int counter; //(2 bytes) - packet counter.
// * 
// *  int src_addr; //(4 bytes)
// *  int dst_addr; //(4 bytes)
// * 
// *  short int src_port; //(2 bytes)
// *  short int dst_port; //(2 bytes)
// * 
// *  int string_ptr; //(4 bytes) - ptr to the string we want to search for in memory
// *  int func_ptr; //(4 bytes) - ptr to the function we give the string to, to search
// *    //for in the packet
// * 
// *  used for chaining the hash table:
// *  int next; (4 bytes) 
// *  int prev; (4 bytes) 

.local zero, sizeOfCacheEntry, policyCacheBase, arrayAccess, compare, ports, chaining

immed[policyCacheBase, POLICY_CACHE_BASE]
immed[zero, 0]
alu[chaining,--,B,0x1]


// The hash multiplier tells the has unit which bits to use from the input when hashing.
// We want this set to FFFF so that all the bits are used...


immed[$xfer7, 0x0ffff]
csr[write,$xfer7, hash_multiplier_64_lo], ctx_swap
csr[write,$xfer7, hash_multiplier_64_hi], ctx_swap


// *  in order to use hashing, first create a tuple containing the appropriate
// *  information to hash on. After that, traverse through the rest of the list to 
// *  find the appropriate entry.
// * 
// *  Note: only the src and dst address are being used to perform the hash. Although
// *  		 this may not be ideal - it means that we can use the hash_64 function trivially,
// * 		 and without complication. Since we're handling hash collisions anyways, it shouldn't
// * 		 affect performance toooo much.


alu[$xfer4, --, B, ip_sa]
alu[$xfer5, --, B, ip_da]
hash1_64[$xfer4], ctx_swap

// we should now have hashed values in $xfer0/$xfer1. Let's
// just use the 16 LSBs of $xfer0 to access our array.
alu[arrayAccess, --, B, $xfer4, <<24] 
alu[arrayAccess, --, B, arrayAccess, >>21]	;24 - 21 = 3 => size of each cache entry is 2^3=8 32bit-words wide.
alu[arrayAccess, arrayAccess, +, policyCacheBase] 

cache_lookup_begin#:
// br[firewall_ok#] ;This is JUST TEMPORARY FOR HASH DETERMINATION PURPOSES!!!!!!!
sram[read, $xfer4, arrayAccess, zero, 1], ctx_swap

// if nothing exists at this hash position, we're done - no match!

alu_shf[compare, zero, B, $xfer4, >>31] ; the MSB of the 1st byte is 1 if this entry is in use
br=0[add_entry_to_cache#], defer[1]
immed[chaining, 0x0]

/// now try to match the entry, else proceed in the chain (if it exists)

alu_shf[compare, zero, +8, $xfer4, >>16]; compare = 2nd MSByte = protocol

alu[compare, compare, XOR, ip_prot]; compare protocol fields...
br!=0[cache_lookup_fail#]

alu[arrayAccess, arrayAccess, +, 0x1]; increment the address:
sram[read, $xfer5, arrayAccess, zero, 3], ctx_swap; load the src/dst address and ports

// compare the source addresses:

alu[compare, ip_sa, XOR, $xfer5]
//if the match was INCORRECT, we'll get a nonzero answer
// so branch
br!=0[cache_lookup_fail#]

// compare the destination addresses:
alu[compare, ip_da, XOR, $xfer6]
//if the match was INCORRECT, we'll get a nonzero answer
// so branch
br!=0[cache_lookup_fail#]

// create a combination of the port info:
alu_shf[ports, zero, +, ip_source_port, <<8]
alu[ports, ip_dest_port, OR, ports]

alu[compare, ports, XOR, $xfer7]
//if the match was INCORRECT, we'll get a nonzero answer
// so branch
br!=0[cache_lookup_fail#]

// if we reached this far, then all of our TUPLES matched.
// now we have to deal with extended features, and then
// deal with a rule match.

br[rule_match#]








cache_lookup_fail#:
// *****
// come here if any portion of the lookup fails 
//	ie. advance in the chain until we reach the end.
// *****
alu[arrayAccess, arrayAccess, +, 0x5] ; increment by 5

sram[read, $xfer5, arrayAccess, zero, 1],ctx_swap ; read in the pointer....

alu[compare, $xfer5, XOR, zero]; if the 'next' pointer is NULL, 
br=0[add_entry_to_cache#] ; then we're done.

alu[arrayAccess, zero, B, $xfer5]; else, update the address with the 'next' pointer
br[cache_lookup_begin#]





add_entry_to_cache#:
// *****
// * we reached the end of the cache without a successful match.
// *****
// *
// * Here we have to enter code to chain this entry on to the 
// * end of the hash table using our 'freelist'.
// * we fill in all the required parameters for the flow, except
// * for the bitvector conatining the decision of the policy lookup.
// * 
// * Then we pass this information up to the control plane. The control
// * plane (StrongARM) then does the lookup of this policy and replies
// * to us when it has filled in the fields. At that point, we should be
// * able to continue by checking the result of the policy.
.local memaddr

alu[--,zero, B, chaining]
br=0[add_entry_no_decr#], defer [1]
alu[memaddr, --, B, arrayAccess]

alu[memaddr, arrayAccess, -, 0x6]
add_entry_no_decr#:

addCacheEntry[arrayAccess, memaddr, chaining]

// * arrayAccess now contains the address of the NEW entry.
// * 
// * ask the control plane to look this entry up...

// * 
// * <CODE INSERT>
// * 

// * now read in the first 32bit word into $xfer4 so that
// * we are consistent with the assumptions of the remaining code...
sram[read, $xfer4, arrayAccess, zero, 1], ctx_swap


.endlocal



rule_match#:
// * 
// * So if we made it this far, that means that we passed
// * all of the tests.
// *  
// * In this case, we have a match, and need to apply
// * the appropriate rule.
// * Note: 
// *  o first update the counter for this flow...
// *  o then remove this flow from the cache if it is
// *    the last packet in a TCP session (approximation)
// * 
// *  $xfer0 still contains the initial 32bit word, of which 
// *   the MSByte looks like this:
// *  
// *  ------------------------------------
// *  |InUse|   |   |   |   |   |Log|Drop|
// *  ------------------------------------
// *     7    6   5   4   3   2   1   0
// *  

#define PERMIT	1
#define LOG		2

.local counter memlocation controlBits

// update the couters for this flow...
alu_shf[compare, zero, +16, $xfer4, >>16] //compare contains the upper word
alu[counter, $xfer4, +16, 0x1] // increment the lower word by one
alu_shf[$xfer4, counter, OR, compare, <<16] // put the two words back together.

alu[arrayAccess, arrayAccess, -, 0x1]; decrement the address:
sram[write, $xfer4, arrayAccess, zero, 1] ; write the updated info

// possibly remove this entry from the cache:

alu[compare, ip_prot, -, 0x6] ;if packet isn't TCP
br!=0[check_permit#]; we're done
 
// *  else:
// * 
// * tcp_control_extract[controlBits,14] ;get control bits
// * alu[compare, TCP_FIN_ACK, -, controlBits] ;see if it's a FIN_ACK
// * br!=0[check_permit#]; if not, we're fine.
// * 
// *  Cache_entry removal code:
// *  P = previous, N = next
// *  if(P== NULL) (head)
// *  	copyCacheEntry(next, this)
// *  	freeCacheEntry(next)
// *  	this.previous = NULL
// *  else
// *  	freeCacheEntry(this)
// * 
alu[memlocation, arrayAccess, +, 0x6] ; increment by 6
sram[read, $xfer5, memlocation, zero, 2]

// * Now: 	$xfer5 = next
// * 		$xfer6 = previous
// * 
alu[--,zero, B, $xfer6]
br!=0[cache_remove_not_head#]
// * If we're here, it means that this *is* the head of the list:
copyCacheEntrytoHead[memlocation, $xfer5]
freeCacheEntry[$xfer5]
br[check_permit#]

cache_remove_not_head#:
freeCacheEntry[memlocation]

.endlocal //counter memlocation controlBits

//immed[compare, LOG]
//alu_shf[compare, compare, AND, $xfer0, >>24]
//br!=0[log_entry#]

check_permit#:
immed[compare, PERMIT]
alu[compare, compare, AND, $xfer4, >>24]

br=0[ip_verify2#] ;branch back up to reclaim all the register space we fucked up.
br[packet_late_discard#] // defined in rec_nextpac.uc

//log_entry#:
// insert logging code

// br[check_permit#]


firewall_ok#:

// This means that we're A-okay. The packet is free to go.

.endlocal ; //firewall definitions.




all_done#:
