
#include <stdio.h>
#include <string.h>
#include "mem_map.h"
#include "config_1200.h"
#include "net_app.h"
#include "ueng.h"
//#include "ipproto.h"


#ifdef MAC_21440
#include "BigMacAPI.h"
#endif

#ifdef ROUTE
#ifdef RTM_MVR
#include "rtm_mvr.h"
#else
#include "rtm.h"
#endif
#endif

#ifdef BRIDGE
#include "brm.h"
#endif

#ifdef WB_SVR
int WbSvr_init();
#endif

#include "end.h"
#include "muxLib.h"
extern "C" {
    extern END_OBJ *pethEndLoad(char *, void *);
}


extern "C" {
/* globals */
IMPORT int ipAttach(int unit, char* pDevice);
}

void initialize_pethmemory();
void start_poller();

#define PETH_NUM_DEVS 8

void initialize_pethmemory(){

SramUnit *sram = SRAM_Attach();
  // Initialize XMIT_PWP_VECTOR in SRAM to zero
   if (NULL == sram) {
            printf("Failed to attach to SRAM, cannot initialize XMIT_PWP_VECTOR\n");
        } else {
            sram->clear_bits((XMIT_PWP_VECTOR<<2), 0xffffffff);
        }

 // Set an undocumented bit in the SRAM csr to help out with
        // the read_lock_spin routine in the SramUnit
        unsigned int csr;
        sram->getSRAM_CSR(&csr);
        sram->setSRAM_CSR(csr | (1 << 4));

}




void start_poller(){

 // Initialize the pseudo ethernet driver
        char pethInitStr[3];
        int pethDrvNum;
        END_OBJ *pEnd;
        void *cookie;

        // For each port create a new instance of the driver
        for (pethDrvNum = 0; pethDrvNum < PETH_NUM_DEVS; ++pethDrvNum) {
            sprintf(pethInitStr, "%d:", pethDrvNum);
            cookie = muxDevLoad(pethDrvNum, pethEndLoad, pethInitStr, 0, NULL);
            if (NULL == cookie) {
                printf("Failed to load Pseudo Ethernet driver number %d\n", 
                       pethDrvNum);
                continue;
            }
            
            // Start the driver
            if (OK != muxDevStart(cookie)) {
                printf("Failed to start Pseudo Ethernet driver number %d\n", 
                       pethDrvNum);
                continue;
            }

            // Attach each driver to the ipStack
            if (OK != ipAttach(pethDrvNum, "peth")) {
                printf("Failed to attach device %d to ip stack\n", pethDrvNum);
            }
        }

}


void mypethdriver(){

 printf("Starting mypethdriver\n");

initialize_pethmemory();
start_poller();

 printf("Stopping mypethdriver\n");

}